/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser.printer.lexicalpreservation;

import coveredclass.org.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import coveredclass.org.github.javaparser.printer.concretesyntaxmodel.CsmMix;
import coveredclass.org.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import coveredclass.org.github.javaparser.printer.lexicalpreservation.DifferenceElement;
import java.util.List;
import java.util.stream.Collectors;

public class Reshuffled
implements DifferenceElement {
    private final CsmMix previousOrder;
    private final CsmMix nextOrder;

    Reshuffled(CsmMix previousOrder, CsmMix nextOrder) {
        this.previousOrder = previousOrder;
        this.nextOrder = nextOrder;
    }

    public String toString() {
        return "Reshuffled{" + this.nextOrder + ", previous=" + this.previousOrder + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reshuffled that = (Reshuffled)o;
        if (!this.previousOrder.equals(that.previousOrder)) {
            return false;
        }
        return this.nextOrder.equals(that.nextOrder);
    }

    public int hashCode() {
        int result = this.previousOrder.hashCode();
        result = 31 * result + this.nextOrder.hashCode();
        return result;
    }

    @Override
    public CsmMix getElement() {
        return this.nextOrder;
    }

    public CsmMix getPreviousOrder() {
        return this.previousOrder;
    }

    public CsmMix getNextOrder() {
        return this.nextOrder;
    }

    @Override
    public boolean isAdded() {
        return false;
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public boolean isKept() {
        return false;
    }

    @Override
    public DifferenceElement replaceEolTokens(CsmElement lineSeparator) {
        CsmMix modifiedNextOrder = new CsmMix(this.replaceTokens(this.nextOrder.getElements(), lineSeparator));
        CsmMix modifiedPreviousOrder = new CsmMix(this.replaceTokens(this.previousOrder.getElements(), lineSeparator));
        return new Reshuffled(modifiedPreviousOrder, modifiedNextOrder);
    }

    private List<CsmElement> replaceTokens(List<CsmElement> elements, CsmElement lineSeparator) {
        return elements.stream().map(element -> this.isNewLineToken((CsmElement)element) ? lineSeparator : element).collect(Collectors.toList());
    }

    private boolean isNewLineToken(CsmElement element) {
        return this.isToken(element) && ((CsmToken)element).isNewLine();
    }

    private boolean isToken(CsmElement element) {
        return element instanceof CsmToken;
    }
}

