/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser.printer.lexicalpreservation;

import coveredclass.org.github.javaparser.printer.lexicalpreservation.LookaheadIterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class PeekingIterator<E>
implements ListIterator<E>,
LookaheadIterator<E> {
    private final ListIterator<E> iterator;
    private boolean exhausted;
    private boolean slotFilled;
    private E slot;

    public <E> PeekingIterator<E> peekingIterator(ListIterator<E> iterator) {
        Objects.requireNonNull(iterator, "iterator");
        if (iterator instanceof PeekingIterator) {
            PeekingIterator it = (PeekingIterator)iterator;
            return it;
        }
        return new PeekingIterator<E>(iterator);
    }

    public PeekingIterator(ListIterator<E> iterator) {
        this.iterator = iterator;
    }

    public PeekingIterator(List<E> list) {
        this.iterator = list.listIterator();
    }

    private void fill() {
        if (this.exhausted || this.slotFilled) {
            return;
        }
        if (this.iterator.hasNext()) {
            this.slot = this.iterator.next();
            this.slotFilled = true;
        } else {
            this.exhausted = true;
            this.slot = null;
            this.slotFilled = false;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.exhausted) {
            return false;
        }
        return this.slotFilled || this.iterator.hasNext();
    }

    @Override
    public E peek() {
        this.fill();
        return this.exhausted ? null : (E)this.slot;
    }

    @Override
    public E element() {
        this.fill();
        if (this.exhausted) {
            throw new NoSuchElementException();
        }
        return this.slot;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E x = this.slotFilled ? this.slot : this.iterator.next();
        this.slot = null;
        this.slotFilled = false;
        return x;
    }

    @Override
    public void remove() {
        if (this.slotFilled) {
            throw new IllegalStateException("peek() or element() called before remove()");
        }
        this.iterator.remove();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public E previous() {
        return this.iterator.previous();
    }

    @Override
    public int nextIndex() {
        return this.iterator.nextIndex();
    }

    public int currentIndex() {
        if (!this.hasPrevious()) {
            return this.previousIndex();
        }
        return this.nextIndex() - 1;
    }

    @Override
    public int previousIndex() {
        return this.iterator.previousIndex();
    }

    @Override
    public void set(E e) {
        if (this.slotFilled) {
            throw new IllegalStateException("peek() or element() called before set()");
        }
        this.iterator.set(e);
    }

    @Override
    public void add(E e) {
        if (this.slotFilled) {
            throw new IllegalStateException("peek() or element() called before add()");
        }
        this.iterator.add(e);
    }
}

