/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser.ast.validator.postprocessors;

import coveredclass.org.github.javaparser.ParseResult;
import coveredclass.org.github.javaparser.ParserConfiguration;
import coveredclass.org.github.javaparser.Processor;
import coveredclass.org.github.javaparser.ast.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PostProcessors {
    private final List<Processor> postProcessors = new ArrayList<Processor>();

    public PostProcessors(Processor ... postProcessors) {
        this.postProcessors.addAll(Arrays.asList(postProcessors));
    }

    public List<Processor> getPostProcessors() {
        return this.postProcessors;
    }

    public PostProcessors remove(Processor postProcessor) {
        if (!this.postProcessors.remove(postProcessor)) {
            throw new AssertionError((Object)"Trying to remove a post processor that isn't there.");
        }
        return this;
    }

    public PostProcessors replace(Processor oldProcessor, Processor newProcessor) {
        this.remove(oldProcessor);
        this.add(newProcessor);
        return this;
    }

    public PostProcessors add(Processor newProcessor) {
        this.postProcessors.add(newProcessor);
        return this;
    }

    public void postProcess(ParseResult<? extends Node> result, ParserConfiguration configuration) {
        this.postProcessors.forEach(pp -> pp.postProcess(result, configuration));
    }
}

