/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser.ast.validator.language_level_validations.chunks;

import coveredclass.org.github.javaparser.ast.Modifier;
import coveredclass.org.github.javaparser.ast.body.RecordDeclaration;
import coveredclass.org.github.javaparser.ast.validator.ProblemReporter;
import coveredclass.org.github.javaparser.ast.validator.TypedValidator;

public class RecordDeclarationValidator
implements TypedValidator<RecordDeclaration> {
    @Override
    public void accept(RecordDeclaration node, ProblemReporter reporter) {
        this.forbidAbstractModifier(node, reporter);
        this.forbidNonStaticFieldsInRecords(node, reporter);
        this.validateRecordComponentAccessorMethods(node, reporter);
    }

    private void forbidAbstractModifier(RecordDeclaration n, ProblemReporter reporter) {
        if (n.getModifiers().contains(Modifier.abstractModifier())) {
            reporter.report(n, "Record Declarations must not be declared as abstract.", new Object[0]);
        }
    }

    private void forbidNonStaticFieldsInRecords(RecordDeclaration n, ProblemReporter reporter) {
        long nonStaticFieldCount = n.getFields().stream().filter(fieldDeclaration -> !fieldDeclaration.isStatic()).count();
        if (nonStaticFieldCount > 0L) {
            reporter.report(n, "Record Declarations must have zero non-static fields.", new Object[0]);
        }
    }

    private void validateRecordComponentAccessorMethods(RecordDeclaration n, ProblemReporter reporter) {
        n.getParameters().forEach(parameter -> n.getMethodsByName(parameter.getNameAsString()).stream().filter(methodDeclaration -> methodDeclaration.getParameters().isEmpty()).forEach(methodDeclaration -> {
            if (!methodDeclaration.getType().equals(parameter.getType())) {
                reporter.report(n, String.format("Incorrect component accessor return type. Expected: '%s', found: '%s'.", parameter.getTypeAsString(), methodDeclaration.getTypeAsString()), new Object[0]);
            }
        }));
    }
}

