/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser;

import coveredclass.org.github.javaparser.ast.Node;
import coveredclass.org.github.javaparser.ast.observer.Observable;
import java.util.Optional;
import java.util.function.Predicate;

public interface HasParentNode<T>
extends Observable {
    default public boolean hasParentNode() {
        return this.getParentNode().isPresent();
    }

    public Optional<Node> getParentNode();

    public T setParentNode(Node var1);

    public Node getParentNodeForChildren();

    default public <N> Optional<N> findAncestor(Class<N> ... types) {
        return this.findAncestor((N x) -> true, types);
    }

    @Deprecated
    default public <N> Optional<N> findAncestor(Class<N> type, Predicate<N> predicate) {
        return this.findAncestor(predicate, type);
    }

    default public <N> Optional<N> findAncestor(Predicate<N> predicate, Class<N> ... types) {
        if (!this.hasParentNode()) {
            return Optional.empty();
        }
        Node parent = this.getParentNode().get();
        for (Class<N> type : types) {
            if (!type.isAssignableFrom(parent.getClass()) || !predicate.test(type.cast(parent))) continue;
            return Optional.of(type.cast(parent));
        }
        return parent.findAncestor(predicate, types);
    }

    default public boolean isDescendantOf(Node ancestor) {
        return this.findAncestor((N n) -> n == ancestor, Node.class).isPresent();
    }
}

