/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.text.similarity;

import coveredclass.org.apache.commons.lang3.ArrayUtils;
import coveredclass.org.apache.commons.lang3.StringUtils;
import coveredclass.org.apache.commons.lang3.Validate;
import coveredclass.org.apache.commons.text.similarity.Tokenizer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RegexTokenizer
implements Tokenizer<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("(\\w)+");

    RegexTokenizer() {
    }

    public CharSequence[] tokenize(CharSequence text) {
        Validate.isTrue(StringUtils.isNotBlank(text), "Invalid text", new Object[0]);
        Matcher matcher = PATTERN.matcher(text);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group(0));
        }
        return tokens.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }
}

