/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.output;

import coveredclass.org.apache.commons.io.IOExceptionList;
import coveredclass.org.apache.commons.io.IOIndexedException;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.KeyForBottom;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class FilterCollectionWriter
extends Writer {
    protected final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Writer> EMPTY_WRITERS = Collections.emptyList();
    protected final @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @Nullable @UnknownKeyFor @Initialized Writer> writers;

    protected FilterCollectionWriter(@Nullable @UnknownKeyFor @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @Nullable @UnknownKeyFor @Initialized Writer> writers) {
        this.writers = writers == null ? this.EMPTY_WRITERS : writers;
    }

    protected FilterCollectionWriter(Writer ... writers) {
        this.writers = writers == null ? this.EMPTY_WRITERS : Arrays.asList(writers);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@UnknownKeyFor @NonNull @Initialized char c) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.append(c);
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence csq) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.append(csq);
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence csq, @UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.append(csq, start, end);
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
        return this;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(cbuf, off, len);
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(cbuf);
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int c) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(c);
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(str);
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<IOIndexedException> causeList = new ArrayList<IOIndexedException>();
        int i = 0;
        for (Writer writer : this.writers) {
            if (writer != null) {
                try {
                    writer.write(str, off, len);
                }
                catch (IOException e) {
                    causeList.add(new IOIndexedException(i, (Throwable)e));
                }
            }
            ++i;
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(causeList);
        }
    }
}

