/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.output;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class ChunkedWriter
extends FilterWriter {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_CHUNK_SIZE = 4096;
    private final @UnknownKeyFor @NonNull @Initialized int chunkSize;

    public ChunkedWriter(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized int chunkSize) {
        super(writer);
        if (chunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = chunkSize;
    }

    public ChunkedWriter(@UnknownKeyFor @NonNull @Initialized Writer writer) {
        this(writer, 4096);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int srcOffset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int bytes = length;
        int dstOffset = srcOffset;
        while (bytes > 0) {
            int chunk = Math.min(bytes, this.chunkSize);
            this.out.write(data, dstOffset, chunk);
            bytes -= chunk;
            dstOffset += chunk;
        }
    }
}

