/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.monitor;

import coveredclass.org.apache.commons.io.monitor.FileAlterationObserver;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;

public final class FileAlterationMonitor
implements Runnable {
    private final @UnknownKeyFor @NonNull @Initialized long interval;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FileAlterationObserver> observers = new CopyOnWriteArrayList<FileAlterationObserver>();
    private @MonotonicNonNull @UnknownKeyFor @Initialized Thread thread;
    private @MonotonicNonNull @UnknownKeyFor @Initialized ThreadFactory threadFactory;
    private volatile @UnknownKeyFor @NonNull @Initialized boolean running = false;

    public FileAlterationMonitor() {
        this(10000L);
    }

    public FileAlterationMonitor(@UnknownKeyFor @NonNull @Initialized long interval) {
        this.interval = interval;
    }

    public FileAlterationMonitor(@UnknownKeyFor @NonNull @Initialized long interval, FileAlterationObserver ... observers) {
        this(interval);
        if (observers != null) {
            for (FileAlterationObserver observer : observers) {
                this.addObserver(observer);
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized long getInterval() {
        return this.interval;
    }

    @EnsuresNonNull(value={"#1"})
    public synchronized void setThreadFactory(@UnknownKeyFor @NonNull @Initialized ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void addObserver(@UnknownKeyFor @NonNull @Initialized FileAlterationObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    public void removeObserver(@UnknownKeyFor @NonNull @Initialized FileAlterationObserver observer) {
        if (observer != null) {
            while (this.observers.remove(observer)) {
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized FileAlterationObserver> getObservers() {
        return this.observers;
    }

    @RequiresNonNull(value={"threadFactory"})
    @EnsuresNonNull(value={"thread"})
    public synchronized void start() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.running) {
            throw new IllegalStateException("Monitor is already running");
        }
        for (FileAlterationObserver observer : this.observers) {
            observer.initialize();
        }
        this.running = true;
        this.thread = this.threadFactory != null ? this.threadFactory.newThread(this) : new Thread(this);
        this.thread.start();
    }

    @RequiresNonNull(value={"thread"})
    public synchronized void stop() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.stop(this.interval);
    }

    @RequiresNonNull(value={"thread"})
    public synchronized void stop(@UnknownKeyFor @NonNull @Initialized long stopInterval) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (!this.running) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.running = false;
        try {
            this.thread.interrupt();
            this.thread.join(stopInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (FileAlterationObserver observer : this.observers) {
            observer.destroy();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            for (FileAlterationObserver observer : this.observers) {
                observer.checkAndNotify();
            }
            if (!this.running) break;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

