/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.InputStream;

public class UnixLineEndingInputStream
extends InputStream {
    private @UnknownKeyFor @NonNull @Initialized boolean slashNSeen = false;
    private @UnknownKeyFor @NonNull @Initialized boolean slashRSeen = false;
    private @UnknownKeyFor @NonNull @Initialized boolean eofSeen = false;
    private final @UnknownKeyFor @NonNull @Initialized InputStream target;
    private final @UnknownKeyFor @NonNull @Initialized boolean ensureLineFeedAtEndOfFile;

    public UnixLineEndingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream in, @UnknownKeyFor @NonNull @Initialized boolean ensureLineFeedAtEndOfFile) {
        this.target = in;
        this.ensureLineFeedAtEndOfFile = ensureLineFeedAtEndOfFile;
    }

    private @UnknownKeyFor @NonNull @Initialized int readWithUpdate() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int target = this.target.read();
        boolean bl = this.eofSeen = target == -1;
        if (this.eofSeen) {
            return target;
        }
        this.slashNSeen = target == 10;
        this.slashRSeen = target == 13;
        return target;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        boolean previousWasSlashR = this.slashRSeen;
        if (this.eofSeen) {
            return this.eofGame(previousWasSlashR);
        }
        int target = this.readWithUpdate();
        if (this.eofSeen) {
            return this.eofGame(previousWasSlashR);
        }
        if (this.slashRSeen) {
            return 10;
        }
        if (previousWasSlashR && this.slashNSeen) {
            return this.read();
        }
        return target;
    }

    private @UnknownKeyFor @NonNull @Initialized int eofGame(@UnknownKeyFor @NonNull @Initialized boolean previousWasSlashR) {
        if (previousWasSlashR || !this.ensureLineFeedAtEndOfFile) {
            return -1;
        }
        if (!this.slashNSeen) {
            this.slashNSeen = true;
            return 10;
        }
        return -1;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        super.close();
        this.target.close();
    }

    @Override
    public synchronized void mark(@UnknownKeyFor @NonNull @Initialized int readlimit) {
        throw new UnsupportedOperationException("Mark notsupported");
    }
}

