/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.apache.commons.io.TaggedIOException;
import coveredclass.org.apache.commons.io.input.ProxyInputStream;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;

public class TaggedInputStream
extends ProxyInputStream {
    private final @UnknownKeyFor @NonNull @Initialized Serializable tag = UUID.randomUUID();

    public TaggedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream proxy) {
        super(proxy);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCauseOf(@UnknownKeyFor @NonNull @Initialized Throwable exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(@UnknownKeyFor @NonNull @Initialized Throwable throwable) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TaggedIOException.throwCauseIfTaggedWith(throwable, this.tag);
    }

    @Override
    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new TaggedIOException(e, this.tag);
    }
}

