/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;

public class ReaderInputStream
extends InputStream {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUFFER_SIZE = 1024;
    private final @UnknownKeyFor @NonNull @Initialized Reader reader;
    private final @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoder;
    private final @UnknownKeyFor @NonNull @Initialized CharBuffer encoderIn;
    private final @UnknownKeyFor @NonNull @Initialized ByteBuffer encoderOut;
    private @MonotonicNonNull @UnknownKeyFor @Initialized CoderResult lastCoderResult;
    private @UnknownKeyFor @NonNull @Initialized boolean endOfInput;

    public ReaderInputStream(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoder) {
        this(reader, encoder, 1024);
    }

    public ReaderInputStream(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoder, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        this.reader = reader;
        this.encoder = encoder;
        this.encoderIn = CharBuffer.allocate(bufferSize);
        this.encoderIn.flip();
        this.encoderOut = ByteBuffer.allocate(128);
        this.encoderOut.flip();
    }

    public ReaderInputStream(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized Charset charset, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        this(reader, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), bufferSize);
    }

    public ReaderInputStream(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized Charset charset) {
        this(reader, charset, 1024);
    }

    public ReaderInputStream(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized String charsetName, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        this(reader, Charset.forName(charsetName), bufferSize);
    }

    public ReaderInputStream(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized String charsetName) {
        this(reader, charsetName, 1024);
    }

    @Deprecated
    public ReaderInputStream(@UnknownKeyFor @NonNull @Initialized Reader reader) {
        this(reader, Charset.defaultCharset());
    }

    @EnsuresNonNull(value={"lastCoderResult"})
    private void fillBuffer() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.endOfInput && (this.lastCoderResult == null || this.lastCoderResult.isUnderflow())) {
            this.encoderIn.compact();
            int position = this.encoderIn.position();
            int c = this.reader.read(this.encoderIn.array(), position, this.encoderIn.remaining());
            if (c == -1) {
                this.endOfInput = true;
            } else {
                this.encoderIn.position(position + c);
            }
            this.encoderIn.flip();
        }
        this.encoderOut.compact();
        this.lastCoderResult = this.encoder.encode(this.encoderIn, this.encoderOut, this.endOfInput);
        this.encoderOut.flip();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] array, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(array, "array");
        if (len < 0 || off < 0 || off + len > array.length) {
            throw new IndexOutOfBoundsException("Array Size=" + array.length + ", offset=" + off + ", length=" + len);
        }
        int read = 0;
        if (len == 0) {
            return 0;
        }
        while (len > 0) {
            if (this.encoderOut.hasRemaining()) {
                int c = Math.min(this.encoderOut.remaining(), len);
                this.encoderOut.get(array, off, c);
                off += c;
                len -= c;
                read += c;
                continue;
            }
            this.fillBuffer();
            if (!this.endOfInput || this.encoderOut.hasRemaining()) continue;
        }
        return read == 0 && this.endOfInput ? -1 : read;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        do {
            if (this.encoderOut.hasRemaining()) {
                return this.encoderOut.get() & 0xFF;
            }
            this.fillBuffer();
        } while (!this.endOfInput || this.encoderOut.hasRemaining());
        return -1;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.reader.close();
    }
}

