/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends InputStream {
    private final @UnknownKeyFor @NonNull @Initialized InputStream in;
    private final @UnknownKeyFor @NonNull @Initialized long max;
    private @UnknownKeyFor @NonNull @Initialized long pos = 0L;
    private @UnknownKeyFor @NonNull @Initialized long mark = -1L;
    private @UnknownKeyFor @NonNull @Initialized boolean propagateClose = true;

    public BoundedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream in, @UnknownKeyFor @NonNull @Initialized long size) {
        this.max = size;
        this.in = in;
    }

    public BoundedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream in) {
        this(in, -1L);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.max >= 0L && this.pos >= this.max) {
            return -1;
        }
        int result = this.in.read();
        ++this.pos;
        return result;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.max >= 0L && this.pos >= this.max) {
            return -1;
        }
        long maxRead = this.max >= 0L ? Math.min((long)len, this.max - this.pos) : (long)len;
        int bytesRead = this.in.read(b, off, (int)maxRead);
        if (bytesRead == -1) {
            return -1;
        }
        this.pos += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized long n) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long toSkip = this.max >= 0L ? Math.min(n, this.max - this.pos) : n;
        long skippedBytes = this.in.skip(toSkip);
        this.pos += skippedBytes;
        return skippedBytes;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int available() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.max >= 0L && this.pos >= this.max) {
            return 0;
        }
        return this.in.available();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.in.toString();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.propagateClose) {
            this.in.close();
        }
    }

    @Override
    public synchronized void reset() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.in.reset();
        this.pos = this.mark;
    }

    @Override
    public synchronized void mark(@UnknownKeyFor @NonNull @Initialized int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.pos;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean markSupported() {
        return this.in.markSupported();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isPropagateClose() {
        return this.propagateClose;
    }

    public void setPropagateClose(@UnknownKeyFor @NonNull @Initialized boolean propagateClose) {
        this.propagateClose = propagateClose;
    }
}

