/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.filefilter;

import coveredclass.org.apache.commons.io.FileUtils;
import coveredclass.org.apache.commons.io.IOCase;
import coveredclass.org.apache.commons.io.filefilter.AgeFileFilter;
import coveredclass.org.apache.commons.io.filefilter.AndFileFilter;
import coveredclass.org.apache.commons.io.filefilter.DelegateFileFilter;
import coveredclass.org.apache.commons.io.filefilter.DirectoryFileFilter;
import coveredclass.org.apache.commons.io.filefilter.FalseFileFilter;
import coveredclass.org.apache.commons.io.filefilter.FileFileFilter;
import coveredclass.org.apache.commons.io.filefilter.IOFileFilter;
import coveredclass.org.apache.commons.io.filefilter.MagicNumberFileFilter;
import coveredclass.org.apache.commons.io.filefilter.NameFileFilter;
import coveredclass.org.apache.commons.io.filefilter.NotFileFilter;
import coveredclass.org.apache.commons.io.filefilter.OrFileFilter;
import coveredclass.org.apache.commons.io.filefilter.PrefixFileFilter;
import coveredclass.org.apache.commons.io.filefilter.SizeFileFilter;
import coveredclass.org.apache.commons.io.filefilter.SuffixFileFilter;
import coveredclass.org.apache.commons.io.filefilter.TrueFileFilter;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FileFilterUtils {
    private static final @UnknownKeyFor @NonNull @Initialized IOFileFilter cvsFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter("CVS")));
    private static final @UnknownKeyFor @NonNull @Initialized IOFileFilter svnFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(".svn")));

    public static @UnknownKeyFor @NonNull @Initialized File @UnknownKeyFor @NonNull @Initialized [] filter(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter, File ... files) {
        if (filter == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (files == null) {
            return FileUtils.EMPTY_FILE_ARRAY;
        }
        ArrayList<File> acceptedFiles = new ArrayList<File>();
        for (File file : files) {
            if (file == null) {
                throw new IllegalArgumentException("file array contains null");
            }
            if (!filter.accept(file)) continue;
            acceptedFiles.add(file);
        }
        return acceptedFiles.toArray(FileUtils.EMPTY_FILE_ARRAY);
    }

    public static @UnknownKeyFor @NonNull @Initialized File @UnknownKeyFor @NonNull @Initialized [] filter(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized File> files) {
        List<File> acceptedFiles = FileFilterUtils.filterList(filter, files);
        return acceptedFiles.toArray(FileUtils.EMPTY_FILE_ARRAY);
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized File> filterList(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized File> files) {
        return FileFilterUtils.filter(filter, files, new ArrayList());
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized File> filterList(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter, File ... files) {
        File[] acceptedFiles = FileFilterUtils.filter(filter, files);
        return Arrays.asList(acceptedFiles);
    }

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized File> filterSet(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter, File ... files) {
        File[] acceptedFiles = FileFilterUtils.filter(filter, files);
        return new HashSet<File>(Arrays.asList(acceptedFiles));
    }

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized File> filterSet(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized File> files) {
        return FileFilterUtils.filter(filter, files, new HashSet());
    }

    private static <T extends Collection<File>> T filter(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized File> files, T acceptedFiles) {
        if (filter == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (files != null) {
            for (File file : files) {
                if (file == null) {
                    throw new IllegalArgumentException("file collection contains null");
                }
                if (!filter.accept(file)) continue;
                acceptedFiles.add((File)file);
            }
        }
        return acceptedFiles;
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter prefixFileFilter(@UnknownKeyFor @NonNull @Initialized String prefix) {
        return new PrefixFileFilter(prefix);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter prefixFileFilter(@UnknownKeyFor @NonNull @Initialized String prefix, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        return new PrefixFileFilter(prefix, caseSensitivity);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter suffixFileFilter(@UnknownKeyFor @NonNull @Initialized String suffix) {
        return new SuffixFileFilter(suffix);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter suffixFileFilter(@UnknownKeyFor @NonNull @Initialized String suffix, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        return new SuffixFileFilter(suffix, caseSensitivity);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter nameFileFilter(@UnknownKeyFor @NonNull @Initialized String name) {
        return new NameFileFilter(name);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter nameFileFilter(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        return new NameFileFilter(name, caseSensitivity);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.DIRECTORY;
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter fileFileFilter() {
        return FileFileFilter.FILE;
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter andFileFilter(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter1, @UnknownKeyFor @NonNull @Initialized IOFileFilter filter2) {
        return new AndFileFilter(filter1, filter2);
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter orFileFilter(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter1, @UnknownKeyFor @NonNull @Initialized IOFileFilter filter2) {
        return new OrFileFilter(filter1, filter2);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter and(IOFileFilter ... filters) {
        return new AndFileFilter(FileFilterUtils.toList(filters));
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter or(IOFileFilter ... filters) {
        return new OrFileFilter(FileFilterUtils.toList(filters));
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized IOFileFilter> toList(IOFileFilter ... filters) {
        if (filters == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        ArrayList<IOFileFilter> list = new ArrayList<IOFileFilter>(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) {
                throw new IllegalArgumentException("The filter[" + i + "] is null");
            }
            list.add(filters[i]);
        }
        return list;
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter notFileFilter(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter) {
        return new NotFileFilter(filter);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter trueFileFilter() {
        return TrueFileFilter.TRUE;
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter falseFileFilter() {
        return FalseFileFilter.FALSE;
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter asFileFilter(@UnknownKeyFor @NonNull @Initialized FileFilter filter) {
        return new DelegateFileFilter(filter);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter asFileFilter(@UnknownKeyFor @NonNull @Initialized FilenameFilter filter) {
        return new DelegateFileFilter(filter);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter ageFileFilter(@UnknownKeyFor @NonNull @Initialized long cutoff) {
        return new AgeFileFilter(cutoff);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter ageFileFilter(@UnknownKeyFor @NonNull @Initialized long cutoff, @UnknownKeyFor @NonNull @Initialized boolean acceptOlder) {
        return new AgeFileFilter(cutoff, acceptOlder);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter ageFileFilter(@UnknownKeyFor @NonNull @Initialized Date cutoffDate) {
        return new AgeFileFilter(cutoffDate);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter ageFileFilter(@UnknownKeyFor @NonNull @Initialized Date cutoffDate, @UnknownKeyFor @NonNull @Initialized boolean acceptOlder) {
        return new AgeFileFilter(cutoffDate, acceptOlder);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter ageFileFilter(@UnknownKeyFor @NonNull @Initialized File cutoffReference) {
        return new AgeFileFilter(cutoffReference);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter ageFileFilter(@UnknownKeyFor @NonNull @Initialized File cutoffReference, @UnknownKeyFor @NonNull @Initialized boolean acceptOlder) {
        return new AgeFileFilter(cutoffReference, acceptOlder);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter sizeFileFilter(@UnknownKeyFor @NonNull @Initialized long threshold) {
        return new SizeFileFilter(threshold);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter sizeFileFilter(@UnknownKeyFor @NonNull @Initialized long threshold, @UnknownKeyFor @NonNull @Initialized boolean acceptLarger) {
        return new SizeFileFilter(threshold, acceptLarger);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter sizeRangeFileFilter(@UnknownKeyFor @NonNull @Initialized long minSizeInclusive, @UnknownKeyFor @NonNull @Initialized long maxSizeInclusive) {
        SizeFileFilter minimumFilter = new SizeFileFilter(minSizeInclusive, true);
        SizeFileFilter maximumFilter = new SizeFileFilter(maxSizeInclusive + 1L, false);
        return new AndFileFilter(minimumFilter, maximumFilter);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter magicNumberFileFilter(@UnknownKeyFor @NonNull @Initialized String magicNumber) {
        return new MagicNumberFileFilter(magicNumber);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter magicNumberFileFilter(@UnknownKeyFor @NonNull @Initialized String magicNumber, @UnknownKeyFor @NonNull @Initialized long offset) {
        return new MagicNumberFileFilter(magicNumber, offset);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter magicNumberFileFilter(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] magicNumber) {
        return new MagicNumberFileFilter(magicNumber);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter magicNumberFileFilter(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] magicNumber, @UnknownKeyFor @NonNull @Initialized long offset) {
        return new MagicNumberFileFilter(magicNumber, offset);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter makeCVSAware(@Nullable @UnknownKeyFor @Initialized IOFileFilter filter) {
        return filter == null ? cvsFilter : FileFilterUtils.and(filter, cvsFilter);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter makeSVNAware(@Nullable @UnknownKeyFor @Initialized IOFileFilter filter) {
        return filter == null ? svnFilter : FileFilterUtils.and(filter, svnFilter);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter makeDirectoryOnly(@Nullable @UnknownKeyFor @Initialized IOFileFilter filter) {
        if (filter == null) {
            return DirectoryFileFilter.DIRECTORY;
        }
        return new AndFileFilter(DirectoryFileFilter.DIRECTORY, filter);
    }

    public static @UnknownKeyFor @NonNull @Initialized IOFileFilter makeFileOnly(@Nullable @UnknownKeyFor @Initialized IOFileFilter filter) {
        if (filter == null) {
            return FileFileFilter.FILE;
        }
        return new AndFileFilter(FileFileFilter.FILE, filter);
    }
}

