/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.file;

import coveredclass.org.apache.commons.io.file.CountingPathVisitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;

public class CopyDirectoryVisitor
extends CountingPathVisitor {
    private static final @UnknownKeyFor @NonNull @Initialized CopyOption @UnknownKeyFor @NonNull @Initialized [] EMPTY_COPY_OPTIONS = new CopyOption[0];
    private final @UnknownKeyFor @NonNull @Initialized CopyOption @UnknownKeyFor @NonNull @Initialized [] copyOptions;
    private final @UnknownKeyFor @NonNull @Initialized Path sourceDirectory;
    private final @UnknownKeyFor @NonNull @Initialized Path targetDirectory;

    public CopyDirectoryVisitor( @UnknownKeyFor @NonNull @Initialized Counters.PathCounters pathCounter, @UnknownKeyFor @NonNull @Initialized Path sourceDirectory, @UnknownKeyFor @NonNull @Initialized Path targetDirectory, CopyOption ... copyOptions) {
        super(pathCounter);
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
        this.copyOptions = copyOptions == null ? EMPTY_COPY_OPTIONS : (CopyOption[])copyOptions.clone();
    }

    protected void copy(@UnknownKeyFor @NonNull @Initialized Path sourceFile, @UnknownKeyFor @NonNull @Initialized Path targetFile) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Files.copy(sourceFile, targetFile, this.copyOptions);
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CopyDirectoryVisitor other = (CopyDirectoryVisitor)obj;
        return Arrays.equals(this.copyOptions, other.copyOptions) && Objects.equals(this.sourceDirectory, other.sourceDirectory) && Objects.equals(this.targetDirectory, other.targetDirectory);
    }

    public @UnknownKeyFor @NonNull @Initialized CopyOption @UnknownKeyFor @NonNull @Initialized [] getCopyOptions() {
        return (CopyOption[])this.copyOptions.clone();
    }

    public @UnknownKeyFor @NonNull @Initialized Path getSourceDirectory() {
        return this.sourceDirectory;
    }

    public @UnknownKeyFor @NonNull @Initialized Path getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.copyOptions);
        result = 31 * result + Objects.hash(this.sourceDirectory, this.targetDirectory);
        return result;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult preVisitDirectory(@UnknownKeyFor @NonNull @Initialized Path directory, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Path newTargetDir = this.targetDirectory.resolve(this.sourceDirectory.relativize(directory));
        if (Files.notExists(newTargetDir, new LinkOption[0])) {
            Files.createDirectory(newTargetDir, new FileAttribute[0]);
        }
        return super.preVisitDirectory(directory, attributes);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult visitFile(@UnknownKeyFor @NonNull @Initialized Path sourceFile, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Path targetFile = this.targetDirectory.resolve(this.sourceDirectory.relativize(sourceFile));
        this.copy(sourceFile, targetFile);
        return super.visitFile(targetFile, attributes);
    }
}

