/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.comparator;

import coveredclass.org.apache.commons.io.FileUtils;
import coveredclass.org.apache.commons.io.comparator.AbstractFileComparator;
import coveredclass.org.apache.commons.io.comparator.ReverseFileComparator;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;

public class SizeFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -1201561106411416190L;
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> SIZE_COMPARATOR = new SizeFileComparator();
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> SIZE_REVERSE = new ReverseFileComparator(SIZE_COMPARATOR);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> SIZE_SUMDIR_COMPARATOR = new SizeFileComparator(true);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> SIZE_SUMDIR_REVERSE = new ReverseFileComparator(SIZE_SUMDIR_COMPARATOR);
    private final @UnknownKeyFor @NonNull @Initialized boolean sumDirectoryContents;

    public SizeFileComparator() {
        this.sumDirectoryContents = false;
    }

    public SizeFileComparator(@UnknownKeyFor @NonNull @Initialized boolean sumDirectoryContents) {
        this.sumDirectoryContents = sumDirectoryContents;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized File file1, @UnknownKeyFor @NonNull @Initialized File file2) {
        long size2;
        long size1 = file1.isDirectory() ? (this.sumDirectoryContents && file1.exists() ? FileUtils.sizeOfDirectory(file1) : 0L) : file1.length();
        long result = size1 - (size2 = file2.isDirectory() ? (this.sumDirectoryContents && file2.exists() ? FileUtils.sizeOfDirectory(file2) : 0L) : file2.length());
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return super.toString() + "[sumDirectoryContents=" + this.sumDirectoryContents + "]";
    }
}

