/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.comparator;

import coveredclass.org.apache.commons.io.IOCase;
import coveredclass.org.apache.commons.io.comparator.AbstractFileComparator;
import coveredclass.org.apache.commons.io.comparator.ReverseFileComparator;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;

public class NameFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 8397947749814525798L;
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> NAME_COMPARATOR = new NameFileComparator();
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> NAME_REVERSE = new ReverseFileComparator(NAME_COMPARATOR);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> NAME_INSENSITIVE_COMPARATOR = new NameFileComparator(IOCase.INSENSITIVE);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> NAME_INSENSITIVE_REVERSE = new ReverseFileComparator(NAME_INSENSITIVE_COMPARATOR);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> NAME_SYSTEM_COMPARATOR = new NameFileComparator(IOCase.SYSTEM);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> NAME_SYSTEM_REVERSE = new ReverseFileComparator(NAME_SYSTEM_COMPARATOR);
    private final @UnknownKeyFor @NonNull @Initialized IOCase caseSensitivity;

    public NameFileComparator() {
        this.caseSensitivity = IOCase.SENSITIVE;
    }

    public NameFileComparator(@Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized File file1, @UnknownKeyFor @NonNull @Initialized File file2) {
        return this.caseSensitivity.checkCompareTo(file1.getName(), file2.getName());
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return super.toString() + "[caseSensitivity=" + (Object)((Object)this.caseSensitivity) + "]";
    }
}

