/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.exec.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public class StringUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final char SLASH_CHAR = '/';
    private static final char BACKSLASH_CHAR = '\\';

    public static String fixFileSeparatorChar(String arg) {
        return arg.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static boolean isQuoted(String argument) {
        return argument.startsWith(SINGLE_QUOTE) && argument.endsWith(SINGLE_QUOTE) || argument.startsWith(DOUBLE_QUOTE) && argument.endsWith(DOUBLE_QUOTE);
    }

    public static String quoteArgument(String argument) {
        String cleanedArgument = argument.trim();
        while (cleanedArgument.startsWith(SINGLE_QUOTE) || cleanedArgument.startsWith(DOUBLE_QUOTE)) {
            cleanedArgument = cleanedArgument.substring(1);
        }
        while (cleanedArgument.endsWith(SINGLE_QUOTE) || cleanedArgument.endsWith(DOUBLE_QUOTE)) {
            cleanedArgument = cleanedArgument.substring(0, cleanedArgument.length() - 1);
        }
        StringBuilder buf = new StringBuilder();
        if (cleanedArgument.contains(DOUBLE_QUOTE)) {
            if (cleanedArgument.contains(SINGLE_QUOTE)) {
                throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
            }
            return buf.append(SINGLE_QUOTE).append(cleanedArgument).append(SINGLE_QUOTE).toString();
        }
        if (cleanedArgument.contains(SINGLE_QUOTE) || cleanedArgument.contains(" ")) {
            return buf.append(DOUBLE_QUOTE).append(cleanedArgument).append(DOUBLE_QUOTE).toString();
        }
        return cleanedArgument;
    }

    public static String[] split(String input, String splitChar) {
        StringTokenizer tokens = new StringTokenizer(input, splitChar);
        ArrayList<String> strList = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            strList.add(tokens.nextToken());
        }
        return strList.toArray(EMPTY_STRING_ARRAY);
    }

    public static StringBuffer stringSubstitution(String argStr, Map<? super String, ?> vars, boolean isLenient) {
        StringBuffer argBuf = new StringBuffer();
        if (argStr == null || argStr.isEmpty()) {
            return argBuf;
        }
        if (vars == null || vars.isEmpty()) {
            return argBuf.append(argStr);
        }
        int argStrLength = argStr.length();
        int cIdx = 0;
        block3: while (cIdx < argStrLength) {
            char ch = argStr.charAt(cIdx);
            int del = 32;
            switch (ch) {
                case '$': {
                    StringBuilder nameBuf = new StringBuilder();
                    del = argStr.charAt(cIdx + 1);
                    if (del == 123) {
                        ++cIdx;
                        ++cIdx;
                        while (cIdx < argStr.length() && ((ch = argStr.charAt(cIdx)) == '_' || ch == '.' || ch == '-' || ch == '+' || Character.isLetterOrDigit(ch))) {
                            nameBuf.append(ch);
                            ++cIdx;
                        }
                        if (nameBuf.length() >= 0) {
                            Object temp = vars.get(nameBuf.toString());
                            String value = temp instanceof File ? StringUtils.fixFileSeparatorChar(((File)temp).getAbsolutePath()) : Objects.toString(temp, null);
                            if (value != null) {
                                argBuf.append(value);
                            } else {
                                if (!isLenient) {
                                    throw new IllegalArgumentException("No value found for : " + nameBuf);
                                }
                                argBuf.append("${").append(nameBuf.toString()).append("}");
                            }
                            del = argStr.charAt(cIdx);
                            if (del != 125) {
                                throw new IllegalArgumentException("Delimiter not found for : " + nameBuf);
                            }
                        }
                    } else {
                        argBuf.append(ch);
                    }
                    ++cIdx;
                    continue block3;
                }
            }
            argBuf.append(ch);
            ++cIdx;
        }
        return argBuf;
    }

    @Deprecated
    public static String toString(String[] strings, String separator) {
        return String.join((CharSequence)separator, strings);
    }

    @Deprecated
    public StringUtils() {
    }
}

