/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.exec.util;

public class DebugUtils {
    public static final String COMMONS_EXEC_LENIENT = "coveredclass.org.apache.commons.exec.lenient";
    public static final String COMMONS_EXEC_DEBUG = "coveredclass.org.apache.commons.exec.debug";

    public static void handleException(String msg, Exception e) {
        if (DebugUtils.isDebugEnabled()) {
            System.err.println(msg);
            e.printStackTrace();
        }
        if (!DebugUtils.isLenientEnabled()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static boolean isDebugEnabled() {
        String debug = System.getProperty(COMMONS_EXEC_DEBUG, Boolean.FALSE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(debug);
    }

    public static boolean isLenientEnabled() {
        String lenient = System.getProperty(COMMONS_EXEC_LENIENT, Boolean.TRUE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(lenient);
    }

    @Deprecated
    public DebugUtils() {
    }
}

