/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.exec.environment;

import coveredclass.org.apache.commons.exec.environment.DefaultProcessingEnvironment;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class EnvironmentUtils {
    private static final DefaultProcessingEnvironment ENVIRONMENT = new DefaultProcessingEnvironment();

    public static void addVariableToEnvironment(Map<String, String> environment, String keyAndValue) {
        String[] parsedVariable = EnvironmentUtils.parseEnvironmentVariable(keyAndValue);
        environment.put(parsedVariable[0], parsedVariable[1]);
    }

    public static Map<String, String> getProcEnvironment() throws IOException {
        return ENVIRONMENT.getProcEnvironment();
    }

    private static String[] parseEnvironmentVariable(String keyAndValue) {
        int index = keyAndValue.indexOf(61);
        if (index == -1) {
            throw new IllegalArgumentException("Environment variable for this platform must contain an equals sign ('=')");
        }
        String[] result = new String[]{keyAndValue.substring(0, index), keyAndValue.substring(index + 1)};
        return result;
    }

    private static String toString(String value) {
        return Objects.toString(value, "");
    }

    public static String[] toStrings(Map<String, String> environment) {
        if (environment == null) {
            return null;
        }
        return (String[])environment.entrySet().stream().map(e -> EnvironmentUtils.toString((String)e.getKey()) + "=" + EnvironmentUtils.toString((String)e.getValue())).toArray(String[]::new);
    }

    private EnvironmentUtils() {
    }
}

