/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.exec;

import coveredclass.org.apache.commons.exec.ThreadUtil;
import coveredclass.org.apache.commons.exec.TimeoutObserver;
import java.time.Duration;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

public class Watchdog
implements Runnable {
    private final Vector<TimeoutObserver> observers = new Vector(1);
    private final long timeoutMillis;
    private boolean stopped;
    private final ThreadFactory threadFactory;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public Watchdog(long timeoutMillis) {
        this(null, Duration.ofMillis(timeoutMillis));
    }

    private Watchdog(ThreadFactory threadFactory, Duration timeout) {
        if (timeout.isNegative() || Duration.ZERO.equals(timeout)) {
            throw new IllegalArgumentException("timeout must not be less than 1.");
        }
        this.timeoutMillis = timeout.toMillis();
        this.threadFactory = threadFactory;
    }

    public void addTimeoutObserver(TimeoutObserver to) {
        this.observers.addElement(to);
    }

    protected final void fireTimeoutOccured() {
        this.observers.forEach(o -> o.timeoutOccured(this));
    }

    public void removeTimeoutObserver(TimeoutObserver to) {
        this.observers.removeElement(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isWaiting;
        long startTimeMillis = System.currentTimeMillis();
        Watchdog watchdog = this;
        synchronized (watchdog) {
            long timeLeftMillis = this.timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
            boolean bl = isWaiting = timeLeftMillis > 0L;
            while (!this.stopped && isWaiting) {
                try {
                    this.wait(timeLeftMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeLeftMillis = this.timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
                isWaiting = timeLeftMillis > 0L;
            }
        }
        if (!isWaiting) {
            this.fireTimeoutOccured();
        }
    }

    public synchronized void start() {
        this.stopped = false;
        ThreadUtil.newThread(this.threadFactory, this, "CommonsExecWatchdog-", true).start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public static final class Builder
    implements Supplier<Watchdog> {
        private ThreadFactory threadFactory;
        private Duration timeout;

        @Override
        public Watchdog get() {
            return new Watchdog(this.threadFactory, this.timeout);
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }
    }
}

