/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.exec;

import coveredclass.org.apache.commons.exec.ProcessDestroyer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class ShutdownHookProcessDestroyer
implements ProcessDestroyer,
Runnable {
    private final Vector<Process> processes = new Vector();
    private ProcessDestroyerThread destroyProcessThread;
    private AtomicBoolean added = new AtomicBoolean();
    private AtomicBoolean running = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Process process) {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            if (this.processes.isEmpty()) {
                this.addShutdownHook();
            }
            this.processes.addElement(process);
            return this.processes.contains(process);
        }
    }

    private void addShutdownHook() {
        if (!this.running.get()) {
            this.destroyProcessThread = new ProcessDestroyerThread();
            Runtime.getRuntime().addShutdownHook(this.destroyProcessThread);
            this.added.compareAndSet(false, true);
        }
    }

    public boolean isAddedAsShutdownHook() {
        return this.added.get();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Process process) {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            boolean processRemoved = this.processes.removeElement(process);
            if (processRemoved && this.processes.isEmpty()) {
                this.removeShutdownHook();
            }
            return processRemoved;
        }
    }

    private void removeShutdownHook() {
        if (this.added.get() && !this.running.get()) {
            boolean removed = Runtime.getRuntime().removeShutdownHook(this.destroyProcessThread);
            if (!removed) {
                System.err.println("Could not remove shutdown hook");
            }
            this.destroyProcessThread.setShouldDestroy(false);
            this.destroyProcessThread.start();
            try {
                this.destroyProcessThread.join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.destroyProcessThread = null;
            this.added.compareAndSet(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            this.running.compareAndSet(false, true);
            this.processes.forEach(process -> {
                try {
                    process.destroy();
                }
                catch (Throwable t2) {
                    System.err.println("Unable to terminate process during process shutdown");
                }
            });
        }
    }

    @Override
    public int size() {
        return this.processes.size();
    }

    private final class ProcessDestroyerThread
    extends Thread {
        private AtomicBoolean shouldDestroy;

        public ProcessDestroyerThread() {
            super("ProcessDestroyer Shutdown Hook");
            this.shouldDestroy = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            if (this.shouldDestroy.get()) {
                ShutdownHookProcessDestroyer.this.run();
            }
        }

        public void setShouldDestroy(boolean shouldDestroy) {
            this.shouldDestroy.compareAndSet(!shouldDestroy, shouldDestroy);
        }
    }
}

