/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.verifier.structurals;

import coveredclass.org.apache.bcel.generic.ReferenceType;
import coveredclass.org.apache.bcel.generic.Type;
import coveredclass.org.apache.bcel.verifier.exc.AssertionViolatedException;
import coveredclass.org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import coveredclass.org.apache.bcel.verifier.structurals.UninitializedObjectType;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;

public class LocalVariables
implements Cloneable {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] locals;

    public LocalVariables(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int localVariableCount) {
        this.locals = new Type[localVariableCount];
        for (int i = 0; i < localVariableCount; ++i) {
            this.locals[i] = Type.UNKNOWN;
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        LocalVariables lvs = new LocalVariables(this.locals.length);
        for (int i = 0; i < this.locals.length; ++i) {
            lvs.locals[i] = this.locals[i];
        }
        return lvs;
    }

    @Pure
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type get(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slotIndex) {
        return this.locals[slotIndex];
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int maxLocals() {
        return this.locals.length;
    }

    public void set(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slotIndex, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[slotIndex] = type;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.locals.length;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object o) {
        if (!(o instanceof LocalVariables)) {
            return false;
        }
        LocalVariables lv = (LocalVariables)o;
        if (this.locals.length != lv.locals.length) {
            return false;
        }
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i].equals(lv.locals[i])) continue;
            return false;
        }
        return true;
    }

    public void merge(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariables localVariable) {
        if (this.locals.length != localVariable.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i = 0; i < this.locals.length; ++i) {
            this.merge(localVariable, i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariables lv, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        try {
            if (!(this.locals[i] instanceof UninitializedObjectType) && lv.locals[i] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (!this.locals[i].equals(lv.locals[i]) && this.locals[i] instanceof UninitializedObjectType && lv.locals[i] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (this.locals[i] instanceof UninitializedObjectType && !(lv.locals[i] instanceof UninitializedObjectType)) {
                this.locals[i] = ((UninitializedObjectType)this.locals[i]).getInitialized();
            }
            if (this.locals[i] instanceof ReferenceType && lv.locals[i] instanceof ReferenceType) {
                if (this.locals[i].equals(lv.locals[i])) return;
                ReferenceType sup = ((ReferenceType)this.locals[i]).getFirstCommonSuperclass((ReferenceType)lv.locals[i]);
                if (sup == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[i] + "' and '" + lv.locals[i] + "'.");
                this.locals[i] = sup;
                return;
            } else {
                if (this.locals[i].equals(lv.locals[i])) return;
                this.locals[i] = Type.UNKNOWN;
            }
            return;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.locals.length; ++i) {
            sb.append(Integer.toString(i));
            sb.append(": ");
            sb.append(this.locals[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void initializeObject(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown UninitializedObjectType uninitializedObjectType) {
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i] != uninitializedObjectType) continue;
            this.locals[i] = uninitializedObjectType.getInitialized();
        }
    }
}

