/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.verifier.structurals;

import coveredclass.org.apache.bcel.generic.CodeExceptionGen;
import coveredclass.org.apache.bcel.generic.InstructionHandle;
import coveredclass.org.apache.bcel.generic.MethodGen;
import coveredclass.org.apache.bcel.verifier.structurals.ExceptionHandler;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExceptionHandlers {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionHandler>> exceptionHandlers = new HashMap<InstructionHandle, Set<ExceptionHandler>>();

    public ExceptionHandlers(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen mg) {
        CodeExceptionGen[] cegs;
        for (CodeExceptionGen ceg : cegs = mg.getExceptionHandlers()) {
            ExceptionHandler eh = new ExceptionHandler(ceg.getCatchType(), ceg.getHandlerPC());
            for (InstructionHandle ih = ceg.getStartPC(); ih != ceg.getEndPC().getNext(); ih = ih.getNext()) {
                Set<ExceptionHandler> hs = this.exceptionHandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet<ExceptionHandler>();
                    this.exceptionHandlers.put(ih, hs);
                }
                hs.add(eh);
            }
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionHandler @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionHandlers(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih) {
        Set<ExceptionHandler> hsSet = this.exceptionHandlers.get(ih);
        if (hsSet == null) {
            return new ExceptionHandler[0];
        }
        return hsSet.toArray(new ExceptionHandler[hsSet.size()]);
    }
}

