/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.verifier.statics;

import coveredclass.org.apache.bcel.Repository;
import coveredclass.org.apache.bcel.classfile.AccessFlags;
import coveredclass.org.apache.bcel.classfile.Attribute;
import coveredclass.org.apache.bcel.classfile.Code;
import coveredclass.org.apache.bcel.classfile.CodeException;
import coveredclass.org.apache.bcel.classfile.Constant;
import coveredclass.org.apache.bcel.classfile.ConstantClass;
import coveredclass.org.apache.bcel.classfile.ConstantDouble;
import coveredclass.org.apache.bcel.classfile.ConstantFieldref;
import coveredclass.org.apache.bcel.classfile.ConstantFloat;
import coveredclass.org.apache.bcel.classfile.ConstantInteger;
import coveredclass.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import coveredclass.org.apache.bcel.classfile.ConstantLong;
import coveredclass.org.apache.bcel.classfile.ConstantMethodref;
import coveredclass.org.apache.bcel.classfile.ConstantNameAndType;
import coveredclass.org.apache.bcel.classfile.ConstantString;
import coveredclass.org.apache.bcel.classfile.ConstantUtf8;
import coveredclass.org.apache.bcel.classfile.Field;
import coveredclass.org.apache.bcel.classfile.FieldOrMethod;
import coveredclass.org.apache.bcel.classfile.JavaClass;
import coveredclass.org.apache.bcel.classfile.LineNumber;
import coveredclass.org.apache.bcel.classfile.LineNumberTable;
import coveredclass.org.apache.bcel.classfile.LocalVariable;
import coveredclass.org.apache.bcel.classfile.LocalVariableTable;
import coveredclass.org.apache.bcel.classfile.Method;
import coveredclass.org.apache.bcel.generic.ALOAD;
import coveredclass.org.apache.bcel.generic.ANEWARRAY;
import coveredclass.org.apache.bcel.generic.ASTORE;
import coveredclass.org.apache.bcel.generic.ATHROW;
import coveredclass.org.apache.bcel.generic.ArrayType;
import coveredclass.org.apache.bcel.generic.BREAKPOINT;
import coveredclass.org.apache.bcel.generic.CHECKCAST;
import coveredclass.org.apache.bcel.generic.ConstantPoolGen;
import coveredclass.org.apache.bcel.generic.DLOAD;
import coveredclass.org.apache.bcel.generic.DSTORE;
import coveredclass.org.apache.bcel.generic.EmptyVisitor;
import coveredclass.org.apache.bcel.generic.FLOAD;
import coveredclass.org.apache.bcel.generic.FSTORE;
import coveredclass.org.apache.bcel.generic.FieldInstruction;
import coveredclass.org.apache.bcel.generic.GETSTATIC;
import coveredclass.org.apache.bcel.generic.GotoInstruction;
import coveredclass.org.apache.bcel.generic.IINC;
import coveredclass.org.apache.bcel.generic.ILOAD;
import coveredclass.org.apache.bcel.generic.IMPDEP1;
import coveredclass.org.apache.bcel.generic.IMPDEP2;
import coveredclass.org.apache.bcel.generic.INSTANCEOF;
import coveredclass.org.apache.bcel.generic.INVOKEDYNAMIC;
import coveredclass.org.apache.bcel.generic.INVOKEINTERFACE;
import coveredclass.org.apache.bcel.generic.INVOKESPECIAL;
import coveredclass.org.apache.bcel.generic.INVOKESTATIC;
import coveredclass.org.apache.bcel.generic.INVOKEVIRTUAL;
import coveredclass.org.apache.bcel.generic.ISTORE;
import coveredclass.org.apache.bcel.generic.Instruction;
import coveredclass.org.apache.bcel.generic.InstructionHandle;
import coveredclass.org.apache.bcel.generic.InstructionList;
import coveredclass.org.apache.bcel.generic.InvokeInstruction;
import coveredclass.org.apache.bcel.generic.JsrInstruction;
import coveredclass.org.apache.bcel.generic.LDC;
import coveredclass.org.apache.bcel.generic.LDC2_W;
import coveredclass.org.apache.bcel.generic.LLOAD;
import coveredclass.org.apache.bcel.generic.LOOKUPSWITCH;
import coveredclass.org.apache.bcel.generic.LSTORE;
import coveredclass.org.apache.bcel.generic.LoadClass;
import coveredclass.org.apache.bcel.generic.MULTIANEWARRAY;
import coveredclass.org.apache.bcel.generic.NEW;
import coveredclass.org.apache.bcel.generic.NEWARRAY;
import coveredclass.org.apache.bcel.generic.ObjectType;
import coveredclass.org.apache.bcel.generic.PUTSTATIC;
import coveredclass.org.apache.bcel.generic.RET;
import coveredclass.org.apache.bcel.generic.ReferenceType;
import coveredclass.org.apache.bcel.generic.ReturnInstruction;
import coveredclass.org.apache.bcel.generic.TABLESWITCH;
import coveredclass.org.apache.bcel.generic.Type;
import coveredclass.org.apache.bcel.verifier.PassVerifier;
import coveredclass.org.apache.bcel.verifier.VerificationResult;
import coveredclass.org.apache.bcel.verifier.Verifier;
import coveredclass.org.apache.bcel.verifier.VerifierFactory;
import coveredclass.org.apache.bcel.verifier.exc.AssertionViolatedException;
import coveredclass.org.apache.bcel.verifier.exc.ClassConstraintException;
import coveredclass.org.apache.bcel.verifier.exc.InvalidMethodException;
import coveredclass.org.apache.bcel.verifier.exc.StaticCodeConstraintException;
import coveredclass.org.apache.bcel.verifier.exc.StaticCodeInstructionConstraintException;
import coveredclass.org.apache.bcel.verifier.exc.StaticCodeInstructionOperandConstraintException;
import coveredclass.org.apache.bcel.verifier.statics.IntList;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class Pass3aVerifier
extends PassVerifier {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier myOwner;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int methodNo;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList instructionList;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Code code;

    public Pass3aVerifier(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier owner, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int methodNo) {
        this.myOwner = owner;
        this.methodNo = methodNo;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerificationResult do_verify() {
        try {
            if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
                JavaClass jc = Repository.lookupClass(this.myOwner.getClassName());
                Method[] methods = jc.getMethods();
                if (this.methodNo >= methods.length) {
                    throw new InvalidMethodException("METHOD DOES NOT EXIST!");
                }
                Method method = methods[this.methodNo];
                this.code = method.getCode();
                if (method.isAbstract() || method.isNative()) {
                    return VerificationResult.VR_OK;
                }
                try {
                    this.instructionList = new InstructionList(method.getCode().getCode());
                }
                catch (RuntimeException re) {
                    return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
                }
                this.instructionList.setPositions(true);
                VerificationResult vr = VerificationResult.VR_OK;
                try {
                    this.delayedPass2Checks();
                }
                catch (ClassConstraintException cce) {
                    vr = new VerificationResult(2, cce.getMessage());
                    return vr;
                }
                try {
                    this.pass3StaticInstructionChecks();
                    this.pass3StaticInstructionOperandsChecks();
                }
                catch (StaticCodeConstraintException scce) {
                    vr = new VerificationResult(2, scce.getMessage());
                }
                catch (ClassCastException cce) {
                    vr = new VerificationResult(2, "Class Cast Exception: " + cce.getMessage());
                }
                return vr;
            }
            return VerificationResult.VR_NOTYET;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    private void delayedPass2Checks() {
        CodeException[] exceptionTable;
        int[] instructionPositions = this.instructionList.getInstructionPositions();
        int codeLength = this.code.getCode().length;
        LineNumberTable lnt = this.code.getLineNumberTable();
        if (lnt != null) {
            LineNumber[] lineNumbers = lnt.getLineNumberTable();
            IntList offsets = new IntList();
            LineNumber[] lineNumberArray = lineNumbers;
            int n = lineNumberArray.length;
            block0: for (int i = 0; i < n; ++i) {
                LineNumber lineNumber = lineNumberArray[i];
                for (int instructionPosition : instructionPositions) {
                    int offset = lineNumber.getStartPC();
                    if (instructionPosition != offset) continue;
                    if (offsets.contains(offset)) {
                        this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + offset + "') more than once which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                        continue block0;
                    }
                    offsets.add(offset);
                    continue block0;
                }
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + lineNumber.getStartPC() + "') that does not exist.");
            }
        }
        Attribute[] atts = this.code.getAttributes();
        for (Attribute att : atts) {
            LocalVariable[] localVariables;
            if (!(att instanceof LocalVariableTable)) continue;
            LocalVariableTable lvt = (LocalVariableTable)att;
            for (LocalVariable localVariable : localVariables = lvt.getLocalVariableTable()) {
                int startpc = localVariable.getStartPC();
                int length = localVariable.getLength();
                if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + startpc + "') that does not exist.");
                }
                if (Pass3aVerifier.contains(instructionPositions, startpc + length) || startpc + length == codeLength) continue;
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (startpc + length) + "') that does not exist.");
            }
        }
        for (CodeException element : exceptionTable = this.code.getExceptionTable()) {
            int startpc = element.getStartPC();
            int endpc = element.getEndPC();
            int handlerpc = element.getHandlerPC();
            if (startpc >= endpc) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + element + "' that has its start_pc ('" + startpc + "') not smaller than its end_pc ('" + endpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + element + "' that has a non-existant bytecode offset as its start_pc ('" + startpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, endpc) && endpc != codeLength) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + element + "' that has a non-existant bytecode offset as its end_pc ('" + startpc + "') [that is also not equal to code_length ('" + codeLength + "')].");
            }
            if (Pass3aVerifier.contains(instructionPositions, handlerpc)) continue;
            throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + element + "' that has a non-existant bytecode offset as its handler_pc ('" + handlerpc + "').");
        }
    }

    private void pass3StaticInstructionChecks() {
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than " + 65536 + "65536 bytes.");
        }
        for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (i instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (i instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (!(i instanceof BREAKPOINT)) continue;
            throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
        }
        Instruction last = this.instructionList.getEnd().getInstruction();
        if (!(last instanceof ReturnInstruction || last instanceof RET || last instanceof GotoInstruction || last instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        try {
            ConstantPoolGen cpg = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
            InstOperandConstraintVisitor v = new InstOperandConstraintVisitor(cpg);
            for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (i instanceof JsrInstruction) {
                    InstructionHandle target = ((JsrInstruction)i).getTarget();
                    if (target == this.instructionList.getStart()) {
                        throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + ih + "' as its target.");
                    }
                    if (!(target.getInstruction() instanceof ASTORE)) {
                        throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + ih + "' targets '" + target + "'.");
                    }
                }
                ih.accept(v);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean contains(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] ints, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        for (int k : ints) {
            if (k != i) continue;
            return true;
        }
        return false;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMethodNo() {
        return this.methodNo;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen constantPoolGen;

        InstOperandConstraintVisitor(ConstantPoolGen constantPoolGen) {
            this.constantPoolGen = constantPoolGen;
        }

        private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_locals() {
            try {
                return Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.methodNo].getCode().getMaxLocals();
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        private void constraintViolated(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String message) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + i + " constraint violated: " + message);
        }

        private void indexValid(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int idx) {
            if (idx < 0 || idx >= this.constantPoolGen.getSize()) {
                this.constraintViolated(i, "Illegal constant pool index '" + idx + "'.");
            }
        }

        @Override
        public void visitLoadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LoadClass loadClass) {
            Verifier v;
            VerificationResult vr;
            ObjectType t2 = loadClass.getLoadClassType(this.constantPoolGen);
            if (t2 != null && (vr = (v = VerifierFactory.getVerifier(t2.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)loadClass), "Class '" + loadClass.getLoadClassType(this.constantPoolGen).getClassName() + "' is referenced, but cannot be loaded: '" + vr + "'.");
            }
        }

        @Override
        public void visitLDC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC ldc) {
            this.indexValid(ldc, ldc.getIndex());
            Constant c = this.constantPoolGen.getConstant(ldc.getIndex());
            if (c instanceof ConstantClass) {
                Pass3aVerifier.this.addMessage("Operand of LDC or LDC_W is CONSTANT_Class '" + c + "' - this is only supported in JDK 1.5 and higher.");
            } else if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString)) {
                this.constraintViolated(ldc, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + c + "'.");
            }
        }

        @Override
        public void visitLDC2_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC2_W o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.constantPoolGen.getConstant(o.getIndex());
            if (!(c instanceof ConstantLong) && !(c instanceof ConstantDouble)) {
                this.constraintViolated(o, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + c + "'.");
            }
            try {
                this.indexValid(o, o.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException e) {
                throw new AssertionViolatedException("Does not BCEL handle that? LDC2_W operand has a problem.", e);
            }
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getObjectType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldInstruction o) {
            ReferenceType rt = o.getReferenceType(this.constantPoolGen);
            if (rt instanceof ObjectType) {
                return (ObjectType)rt;
            }
            this.constraintViolated(o, "expecting ObjectType but got " + rt);
            return null;
        }

        @Override
        public void visitFieldInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldInstruction o) {
            try {
                this.indexValid(o, o.getIndex());
                Constant c = this.constantPoolGen.getConstant(o.getIndex());
                if (!(c instanceof ConstantFieldref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + c + "'.");
                }
                String field_name = o.getFieldName(this.constantPoolGen);
                JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
                Field[] fields = jc.getFields();
                FieldOrMethod f = null;
                for (Field field : fields) {
                    Type o_type;
                    Type f_type;
                    if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.constantPoolGen))) continue;
                    f = field;
                    break;
                }
                if (f == null) {
                    JavaClass[] superclasses;
                    block3: for (JavaClass superclass : superclasses = jc.getSuperClasses()) {
                        for (Field field : fields = superclass.getFields()) {
                            Type o_type;
                            Type f_type;
                            if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.constantPoolGen))) continue;
                            f = field;
                            if ((f.getAccessFlags() & 5) != 0) break block3;
                            f = null;
                            break block3;
                        }
                    }
                    if (f == null) {
                        this.constraintViolated(o, "Referenced field '" + field_name + "' does not exist in class '" + jc.getClassName() + "'.");
                    }
                } else {
                    Type.getType(f.getSignature());
                    o.getType(this.constantPoolGen);
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitInvokeInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InvokeInstruction o) {
            Type[] ts;
            Verifier v;
            VerificationResult vr;
            ConstantNameAndType cnat;
            Constant c;
            this.indexValid(o, o.getIndex());
            if (o instanceof INVOKEVIRTUAL || o instanceof INVOKESPECIAL || o instanceof INVOKESTATIC) {
                c = this.constantPoolGen.getConstant(o.getIndex());
                if (!(c instanceof ConstantMethodref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_Methodref but a '" + c + "'.");
                } else {
                    cnat = (ConstantNameAndType)this.constantPoolGen.getConstant(((ConstantMethodref)c).getNameAndTypeIndex());
                    ConstantUtf8 cutf8 = (ConstantUtf8)this.constantPoolGen.getConstant(cnat.getNameIndex());
                    if (cutf8.getBytes().equals("<init>") && !(o instanceof INVOKESPECIAL)) {
                        this.constraintViolated(o, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!cutf8.getBytes().equals("<init>") && cutf8.getBytes().startsWith("<")) {
                        this.constraintViolated(o, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                String name;
                c = this.constantPoolGen.getConstant(o.getIndex());
                if (!(c instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + c + "'.");
                }
                if ((name = ((ConstantUtf8)this.constantPoolGen.getConstant((cnat = (ConstantNameAndType)this.constantPoolGen.getConstant(((ConstantInterfaceMethodref)c).getNameAndTypeIndex())).getNameIndex())).getBytes()).equals("<init>")) {
                    this.constraintViolated(o, "Method to invoke must not be '<init>'.");
                }
                if (name.equals("<clinit>")) {
                    this.constraintViolated(o, "Method to invoke must not be '<clinit>'.");
                }
            }
            Type t2 = o.getReturnType(this.constantPoolGen);
            if (t2 instanceof ArrayType) {
                t2 = ((ArrayType)t2).getBasicType();
            }
            if (t2 instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(((ObjectType)t2).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Return type class/interface could not be verified successfully: '" + vr.getMessage() + "'.");
            }
            for (Type element : ts = o.getArgumentTypes(this.constantPoolGen)) {
                Verifier v2;
                VerificationResult vr2;
                t2 = element;
                if (t2 instanceof ArrayType) {
                    t2 = ((ArrayType)t2).getBasicType();
                }
                if (!(t2 instanceof ObjectType) || (vr2 = (v2 = VerifierFactory.getVerifier(((ObjectType)t2).getClassName())).doPass2()).getStatus() == 1) continue;
                this.constraintViolated(o, "Argument type class/interface could not be verified successfully: '" + vr2.getMessage() + "'.");
            }
        }

        @Override
        public void visitINSTANCEOF(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INSTANCEOF o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.constantPoolGen.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
        }

        @Override
        public void visitCHECKCAST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CHECKCAST o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.constantPoolGen.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
        }

        @Override
        public void visitNEW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NEW o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.constantPoolGen.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            } else {
                ConstantUtf8 cutf8 = (ConstantUtf8)this.constantPoolGen.getConstant(((ConstantClass)c).getNameIndex());
                Type t2 = Type.getType("L" + cutf8.getBytes() + ";");
                if (t2 instanceof ArrayType) {
                    this.constraintViolated(o, "NEW must not be used to create an array.");
                }
            }
        }

        @Override
        public void visitMULTIANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MULTIANEWARRAY o) {
            Type t2;
            short dimensions2create;
            this.indexValid(o, o.getIndex());
            Constant c = this.constantPoolGen.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
            if ((dimensions2create = o.getDimensions()) < 1) {
                this.constraintViolated(o, "Number of dimensions to create must be greater than zero.");
            }
            if ((t2 = o.getType(this.constantPoolGen)) instanceof ArrayType) {
                int dimensions = ((ArrayType)t2).getDimensions();
                if (dimensions < dimensions2create) {
                    this.constraintViolated(o, "Not allowed to create array with more dimensions ('" + dimensions2create + "') than the one referenced by the CONSTANT_Class '" + t2 + "'.");
                }
            } else {
                this.constraintViolated(o, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        @Override
        public void visitANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ANEWARRAY o) {
            int dimensions;
            Type t2;
            this.indexValid(o, o.getIndex());
            Constant c = this.constantPoolGen.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
            if ((t2 = o.getType(this.constantPoolGen)) instanceof ArrayType && (dimensions = ((ArrayType)t2).getDimensions()) > 255) {
                this.constraintViolated(o, "Not allowed to create an array with more than 255 dimensions; actual: " + dimensions);
            }
        }

        @Override
        public void visitNEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NEWARRAY o) {
            byte t2 = o.getTypecode();
            if (t2 != 4 && t2 != 5 && t2 != 6 && t2 != 7 && t2 != 8 && t2 != 9 && t2 != 10 && t2 != 11) {
                this.constraintViolated(o, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        @Override
        public void visitILOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ILOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitFLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ALOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitISTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitFSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ASTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitIINC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IINC o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitRET(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown RET o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitLLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitDLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitLSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitDSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitLOOKUPSWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LOOKUPSWITCH o) {
            int[] matchs = o.getMatchs();
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < matchs.length; ++i) {
                if (matchs[i] == max && i != 0) {
                    this.constraintViolated(o, "Match '" + matchs[i] + "' occurs more than once.");
                }
                if (matchs[i] < max) {
                    this.constraintViolated(o, "Lookup table must be sorted but isn't.");
                    continue;
                }
                max = matchs[i];
            }
        }

        @Override
        public void visitTABLESWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown TABLESWITCH o) {
        }

        @Override
        public void visitPUTSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PUTSTATIC o) {
            try {
                String field_name = o.getFieldName(this.constantPoolGen);
                JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
                Field[] fields = jc.getFields();
                AccessFlags f = null;
                for (Field field : fields) {
                    if (!field.getName().equals(field_name)) continue;
                    f = field;
                    break;
                }
                if (f == null) {
                    throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
                }
                if (f.isFinal() && !Pass3aVerifier.this.myOwner.getClassName().equals(this.getObjectType(o).getClassName())) {
                    this.constraintViolated(o, "Referenced field '" + f + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.this.myOwner.getClassName() + "' which is not the case: it is declared in '" + o.getReferenceType(this.constantPoolGen) + "'.");
                }
                if (!f.isStatic()) {
                    this.constraintViolated(o, "Referenced field '" + f + "' is not static which it should be.");
                }
                String meth_name = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.methodNo].getName();
                if (!jc.isClass() && !meth_name.equals("<clinit>")) {
                    this.constraintViolated(o, "Interface field '" + f + "' must be set in a '" + "<clinit>" + "' method.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitGETSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GETSTATIC o) {
            try {
                String field_name = o.getFieldName(this.constantPoolGen);
                JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
                Field[] fields = jc.getFields();
                AccessFlags f = null;
                for (Field field : fields) {
                    if (!field.getName().equals(field_name)) continue;
                    f = field;
                    break;
                }
                if (f == null) {
                    throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
                }
                if (!f.isStatic()) {
                    this.constraintViolated(o, "Referenced field '" + f + "' is not static which it should be.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitINVOKEDYNAMIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEDYNAMIC o) {
            throw new UnsupportedOperationException("INVOKEDYNAMIC instruction is not supported at this time");
        }

        @Override
        public void visitINVOKEINTERFACE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEINTERFACE o) {
            try {
                String classname = o.getClassName(this.constantPoolGen);
                JavaClass jc = Repository.lookupClass(classname);
                Method m4 = this.getMethodRecursive(jc, o);
                if (m4 == null) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.constantPoolGen) + "' with expected signature '" + o.getSignature(this.constantPoolGen) + "' not found in class '" + jc.getClassName() + "'.");
                }
                if (jc.isClass()) {
                    this.constraintViolated(o, "Referenced class '" + jc.getClassName() + "' is a class, but not an interface as expected.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        private @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Method getMethodRecursive(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass jc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InvokeInstruction invoke) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
            Method m4 = this.getMethod(jc, invoke);
            if (m4 != null) {
                return m4;
            }
            for (JavaClass superclass : jc.getSuperClasses()) {
                m4 = this.getMethod(superclass, invoke);
                if (m4 == null) continue;
                return m4;
            }
            for (JavaClass superclass : jc.getInterfaces()) {
                m4 = this.getMethod(superclass, invoke);
                if (m4 == null) continue;
                return m4;
            }
            return null;
        }

        private @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Method getMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass jc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InvokeInstruction invoke) {
            Method[] ms;
            for (Method element : ms = jc.getMethods()) {
                if (!element.getName().equals(invoke.getMethodName(this.constantPoolGen)) || !Type.getReturnType(element.getSignature()).equals(invoke.getReturnType(this.constantPoolGen)) || !this.objarrayequals(Type.getArgumentTypes(element.getSignature()), invoke.getArgumentTypes(this.constantPoolGen))) continue;
                return element;
            }
            return null;
        }

        @Override
        public void visitINVOKESPECIAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKESPECIAL o) {
            try {
                JavaClass current;
                String classname = o.getClassName(this.constantPoolGen);
                JavaClass jc = Repository.lookupClass(classname);
                Method m4 = this.getMethodRecursive(jc, o);
                if (m4 == null) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.constantPoolGen) + "' with expected signature '" + o.getSignature(this.constantPoolGen) + "' not found in class '" + jc.getClassName() + "'.");
                }
                if ((current = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName())).isSuper() && Repository.instanceOf(current, jc) && !current.equals(jc) && !o.getMethodName(this.constantPoolGen).equals("<init>")) {
                    int supidx = -1;
                    Method meth = null;
                    while (supidx != 0) {
                        Method[] meths;
                        supidx = current.getSuperclassNameIndex();
                        current = Repository.lookupClass(current.getSuperclassName());
                        for (Method meth2 : meths = current.getMethods()) {
                            if (!meth2.getName().equals(o.getMethodName(this.constantPoolGen)) || !Type.getReturnType(meth2.getSignature()).equals(o.getReturnType(this.constantPoolGen)) || !this.objarrayequals(Type.getArgumentTypes(meth2.getSignature()), o.getArgumentTypes(this.constantPoolGen))) continue;
                            meth = meth2;
                            break;
                        }
                        if (meth == null) continue;
                        break;
                    }
                    if (meth == null) {
                        this.constraintViolated(o, "ACC_SUPER special lookup procedure not successful: method '" + o.getMethodName(this.constantPoolGen) + "' with proper signature not declared in superclass hierarchy.");
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitINVOKESTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKESTATIC o) {
            try {
                String classname = o.getClassName(this.constantPoolGen);
                JavaClass jc = Repository.lookupClass(classname);
                Method m4 = this.getMethodRecursive(jc, o);
                if (m4 == null) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.constantPoolGen) + "' with expected signature '" + o.getSignature(this.constantPoolGen) + "' not found in class '" + jc.getClassName() + "'.");
                } else if (!m4.isStatic()) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.constantPoolGen) + "' has ACC_STATIC unset.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitINVOKEVIRTUAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEVIRTUAL o) {
            try {
                String classname = o.getClassName(this.constantPoolGen);
                JavaClass jc = Repository.lookupClass(classname);
                Method m4 = this.getMethodRecursive(jc, o);
                if (m4 == null) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.constantPoolGen) + "' with expected signature '" + o.getSignature(this.constantPoolGen) + "' not found in class '" + jc.getClassName() + "'.");
                }
                if (!jc.isClass()) {
                    this.constraintViolated(o, "Referenced class '" + jc.getClassName() + "' is an interface, but not a class as expected.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean objarrayequals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] p) {
            if (o.length != p.length) {
                return false;
            }
            for (int i = 0; i < o.length; ++i) {
                if (o[i].equals(p[i])) continue;
                return false;
            }
            return true;
        }
    }
}

