/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.verifier;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.InternedDistinct;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;

public class VerificationResult {
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int VERIFIED_NOTYET = 0;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int VERIFIED_OK = 1;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int VERIFIED_REJECTED = 2;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String VERIFIED_NOTYET_MSG = "Not yet verified.";
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String VERIFIED_OK_MSG = "Passed verification.";
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerificationResult VR_NOTYET = new VerificationResult(0, "Not yet verified.");
    public static final @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerificationResult VR_OK = new VerificationResult(1, "Passed verification.");
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int numeric;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String detailMessage;

    public VerificationResult(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int status, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String message) {
        this.numeric = status;
        this.detailMessage = message;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getStatus() {
        return this.numeric;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getMessage() {
        return this.detailMessage;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.numeric ^ this.detailMessage.hashCode();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object o) {
        if (!(o instanceof VerificationResult)) {
            return false;
        }
        VerificationResult other = (VerificationResult)o;
        return other.numeric == this.numeric && other.detailMessage.equals(this.detailMessage);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String ret = "";
        if (this.numeric == 0) {
            ret = "VERIFIED_NOTYET";
        }
        if (this.numeric == 1) {
            ret = "VERIFIED_OK";
        }
        if (this.numeric == 2) {
            ret = "VERIFIED_REJECTED";
        }
        ret = ret + "\n" + this.detailMessage + "\n";
        return ret;
    }
}

