/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.util;

import coveredclass.org.apache.bcel.Const;
import coveredclass.org.apache.bcel.classfile.Attribute;
import coveredclass.org.apache.bcel.classfile.Code;
import coveredclass.org.apache.bcel.classfile.CodeException;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.ConstantUtf8;
import coveredclass.org.apache.bcel.classfile.ConstantValue;
import coveredclass.org.apache.bcel.classfile.ExceptionTable;
import coveredclass.org.apache.bcel.classfile.InnerClass;
import coveredclass.org.apache.bcel.classfile.InnerClasses;
import coveredclass.org.apache.bcel.classfile.LineNumber;
import coveredclass.org.apache.bcel.classfile.LineNumberTable;
import coveredclass.org.apache.bcel.classfile.LocalVariable;
import coveredclass.org.apache.bcel.classfile.LocalVariableTable;
import coveredclass.org.apache.bcel.classfile.SourceFile;
import coveredclass.org.apache.bcel.classfile.Utility;
import coveredclass.org.apache.bcel.util.Class2HTML;
import coveredclass.org.apache.bcel.util.ConstantHTML;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class AttributeHTML {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PrintWriter file;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int attr_count = 0;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantHTML constant_html;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool;

    AttributeHTML(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String dir, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantHTML constant_html) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.class_name = class_name;
        this.constant_pool = constant_pool;
        this.constant_html = constant_html;
        this.file = new PrintWriter(new FileOutputStream(dir + class_name + "_attributes.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String codeLink(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int link, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int method_number) {
        return "<A HREF=\"" + this.class_name + "_code.html#code" + method_number + "@" + link + "\" TARGET=Code>" + link + "</A>";
    }

    void close() {
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    void writeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute attribute, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String anchor) {
        this.writeAttribute(attribute, anchor, 0);
    }

    void writeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute attribute, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String anchor, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int method_number) {
        byte tag = attribute.getTag();
        if (tag == -1) {
            return;
        }
        ++this.attr_count;
        if (this.attr_count % 2 == 0) {
            this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
        } else {
            this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
        }
        this.file.println("<H4><A NAME=\"" + anchor + "\">" + this.attr_count + " " + Const.getAttributeName(tag) + "</A></H4>");
        switch (tag) {
            case 2: {
                Code c = (Code)attribute;
                this.file.print("<UL><LI>Maximum stack size = " + c.getMaxStack() + "</LI>\n<LI>Number of local variables = " + c.getMaxLocals() + "</LI>\n<LI><A HREF=\"" + this.class_name + "_code.html#method" + method_number + "\" TARGET=Code>Byte code</A></LI></UL>\n");
                CodeException[] ce = c.getExceptionTable();
                int len = ce.length;
                if (len <= 0) break;
                this.file.print("<P><B>Exceptions handled</B><UL>");
                for (CodeException cex : ce) {
                    int catch_type = cex.getCatchType();
                    this.file.print("<LI>");
                    if (catch_type != 0) {
                        this.file.print(this.constant_html.referenceConstant(catch_type));
                    } else {
                        this.file.print("Any Exception");
                    }
                    this.file.print("<BR>(Ranging from lines " + this.codeLink(cex.getStartPC(), method_number) + " to " + this.codeLink(cex.getEndPC(), method_number) + ", handled at line " + this.codeLink(cex.getHandlerPC(), method_number) + ")</LI>");
                }
                this.file.print("</UL>");
                break;
            }
            case 1: {
                int index = ((ConstantValue)attribute).getConstantValueIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + index + "\" TARGET=\"ConstantPool\">Constant value index(" + index + ")</A></UL>\n");
                break;
            }
            case 0: {
                int index = ((SourceFile)attribute).getSourceFileIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + index + "\" TARGET=\"ConstantPool\">Source file index(" + index + ")</A></UL>\n");
                break;
            }
            case 3: {
                int[] indices = ((ExceptionTable)attribute).getExceptionIndexTable();
                this.file.print("<UL>");
                for (int indice : indices) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_cp.html#cp" + indice + "\" TARGET=\"ConstantPool\">Exception class index(" + indice + ")</A>\n");
                }
                this.file.print("</UL>\n");
                break;
            }
            case 4: {
                LineNumber[] line_numbers = ((LineNumberTable)attribute).getLineNumberTable();
                this.file.print("<P>");
                for (int i = 0; i < line_numbers.length; ++i) {
                    this.file.print("(" + line_numbers[i].getStartPC() + ",&nbsp;" + line_numbers[i].getLineNumber() + ")");
                    if (i >= line_numbers.length - 1) continue;
                    this.file.print(", ");
                }
                break;
            }
            case 5: {
                LocalVariable[] vars = ((LocalVariableTable)attribute).getLocalVariableTable();
                this.file.print("<UL>");
                for (LocalVariable var : vars) {
                    int index = var.getSignatureIndex();
                    String signature = ((ConstantUtf8)this.constant_pool.getConstant(index, (byte)1)).getBytes();
                    signature = Utility.signatureToString(signature, false);
                    int start = var.getStartPC();
                    int end = start + var.getLength();
                    this.file.println("<LI>" + Class2HTML.referenceType(signature) + "&nbsp;<B>" + var.getName() + "</B> in slot %" + var.getIndex() + "<BR>Valid from lines <A HREF=\"" + this.class_name + "_code.html#code" + method_number + "@" + start + "\" TARGET=Code>" + start + "</A> to <A HREF=\"" + this.class_name + "_code.html#code" + method_number + "@" + end + "\" TARGET=Code>" + end + "</A></LI>");
                }
                this.file.print("</UL>\n");
                break;
            }
            case 6: {
                InnerClass[] classes = ((InnerClasses)attribute).getInnerClasses();
                this.file.print("<UL>");
                for (InnerClass classe : classes) {
                    int index = classe.getInnerNameIndex();
                    String name = index > 0 ? ((ConstantUtf8)this.constant_pool.getConstant(index, (byte)1)).getBytes() : "&lt;anonymous&gt;";
                    String access = Utility.accessToString(classe.getInnerAccessFlags());
                    this.file.print("<LI><FONT COLOR=\"#FF0000\">" + access + "</FONT> " + this.constant_html.referenceConstant(classe.getInnerClassIndex()) + " in&nbsp;class " + this.constant_html.referenceConstant(classe.getOuterClassIndex()) + " named " + name + "</LI>\n");
                }
                this.file.print("</UL>\n");
                break;
            }
            default: {
                this.file.print("<P>" + attribute);
            }
        }
        this.file.println("</TD></TR>");
        this.file.flush();
    }
}

