/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.util;

import coveredclass.org.apache.bcel.classfile.ClassParser;
import coveredclass.org.apache.bcel.classfile.JavaClass;
import coveredclass.org.apache.bcel.util.ClassPath;
import coveredclass.org.apache.bcel.util.Repository;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.InternedDistinct;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.IOException;
import java.io.InputStream;

abstract class AbstractClassPathRepository
implements Repository {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath _path;

    AbstractClassPathRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath classPath) {
        this._path = classPath;
    }

    @Override
    public abstract void storeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass var1);

    @Override
    public abstract void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass var1);

    @Override
    public abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass findClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var1);

    @Override
    public abstract void clear();

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        if (className == null || className.isEmpty()) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = className.replace('/', '.'));
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.loadClass(this._path.getInputStream(className), className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass loadClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @InternedDistinct @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?> clazz) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        String className = clazz.getName();
        JavaClass repositoryClass = this.findClass(className);
        if (repositoryClass != null) {
            return repositoryClass;
        }
        String name = className;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        try (InputStream clsStream = clazz.getResourceAsStream(name + ".class");){
            JavaClass javaClass = this.loadClass(clsStream, className);
            return javaClass;
        }
        catch (IOException e) {
            return null;
        }
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream inputStream, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        try {
            if (inputStream != null) {
                ClassParser parser = new ClassParser(inputStream, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                JavaClass javaClass = clazz;
                return javaClass;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new ClassNotFoundException("ClassRepository could not load " + className);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath getClassPath() {
        return this._path;
    }
}

