/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.generic;

import coveredclass.org.apache.bcel.generic.ClassGenException;
import coveredclass.org.apache.bcel.generic.Instruction;
import coveredclass.org.apache.bcel.generic.InstructionHandle;
import coveredclass.org.apache.bcel.generic.InstructionTargeter;
import coveredclass.org.apache.bcel.util.ByteSequence;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.interning.qual.UsesObjectEquals;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.DataOutputStream;
import java.io.IOException;

@UsesObjectEquals
public abstract class BranchInstruction
extends Instruction
implements InstructionTargeter {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int position;

    BranchInstruction() {
    }

    protected BranchInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short opcode, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target) {
        super(opcode, (short)3);
        this.setTarget(target);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        out.writeByte(super.getOpcode());
        this.index = this.getTargetOffset();
        if (!BranchInstruction.isValidShort(this.index)) {
            throw new ClassGenException("Branch target offset too large for short: " + this.index);
        }
        out.writeShort(this.index);
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTargetOffset(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle _target) {
        if (_target == null) {
            throw new ClassGenException("Target of " + super.toString(true) + " is invalid null handle");
        }
        int t2 = _target.getPosition();
        if (t2 < 0) {
            throw new ClassGenException("Invalid branch target position offset for " + super.toString(true) + ":" + t2 + ":" + _target);
        }
        return t2 - this.position;
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTargetOffset() {
        return this.getTargetOffset(this.target);
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int updatePosition(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int offset, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_offset) {
        this.position += offset;
        return 0;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        String s2 = super.toString(verbose);
        String t2 = "null";
        if (verbose) {
            if (this.target != null) {
                t2 = this.target.getInstruction() == this ? "<points to itself>" : (this.target.getInstruction() == null ? "<null instruction!!!?>" : "" + this.target.getPosition());
            }
        } else if (this.target != null) {
            this.index = this.target.getPosition();
            t2 = "" + this.index;
        }
        return s2 + " -> " + t2;
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.setLength(3);
        this.index = bytes.readShort();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getTarget() {
        return this.target;
    }

    @EnsuresNonNull(value={"this.target"})
    public void setTarget(@UnknownInitialization(value=BranchInstruction.class) BranchInstruction this, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target) {
        BranchInstruction.notifyTarget(this.target, target, this);
        this.target = target;
    }

    static void notifyTarget(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InstructionHandle old_ih, @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InstructionHandle new_ih, @UnknownInitialization(value=InstructionTargeter.class) @UnknownInterned @UnknownKeyFor @NonNull @UnknownInitialization(value=InstructionTargeter.class) @SignatureUnknown InstructionTargeter t2) {
        if (old_ih != null) {
            old_ih.removeTargeter(t2);
        }
        if (new_ih != null) {
            new_ih.addTargeter(t2);
        }
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle new_ih) {
        if (this.target != old_ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.target);
        }
        this.setTarget(new_ih);
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih) {
        return this.target == ih;
    }

    @Override
    void dispose() {
        this.setTarget(null);
        this.index = -1;
        this.position = -1;
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getPosition() {
        return this.position;
    }

    protected void setPosition(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int position) {
        this.position = position;
    }

    protected void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        this.index = index;
    }
}

