/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.Const;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapType
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index = -1;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool;

    StackMapType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readByte(), -1, constant_pool);
        if (this.hasIndex()) {
            this.index = file.readShort();
        }
        this.constantPool = constant_pool;
    }

    public StackMapType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        if (type < 0 || type > 8) {
            throw new IllegalArgumentException("Illegal type for StackMapType: " + type);
        }
        this.type = type;
        this.index = index;
        this.constantPool = constant_pool;
    }

    public void setType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte t2) {
        if (t2 < 0 || t2 > 8) {
            throw new IllegalArgumentException("Illegal type for StackMapType: " + t2);
        }
        this.type = t2;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte getType() {
        return this.type;
    }

    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int t2) {
        this.index = t2;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.index;
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(this.type);
        if (this.hasIndex()) {
            file.writeShort(this.getIndex());
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean hasIndex() {
        return this.type == 7 || this.type == 8;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String printIndex() {
        if (this.type == 7) {
            if (this.index < 0) {
                return ", class=<unknown>";
            }
            return ", class=" + this.constantPool.constantToString(this.index, (byte)7);
        }
        if (this.type == 8) {
            return ", offset=" + this.index;
        }
        return "";
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "(type=" + Const.getItemName(this.type) + this.printIndex() + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType copy() {
        try {
            return (StackMapType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        this.constantPool = constantPool;
    }
}

