/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.ConstantDouble;
import coveredclass.org.apache.bcel.classfile.ConstantFloat;
import coveredclass.org.apache.bcel.classfile.ConstantInteger;
import coveredclass.org.apache.bcel.classfile.ConstantLong;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.ConstantUtf8;
import coveredclass.org.apache.bcel.classfile.ElementValue;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimpleElementValue
extends ElementValue {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index;

    public SimpleElementValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) {
        super(type, cpool);
        this.index = index;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.index;
    }

    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        this.index = index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getValueString() {
        if (super.getType() != 115) {
            throw new IllegalStateException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(this.getIndex(), (byte)1);
        return c.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getValueInt() {
        if (super.getType() != 73) {
            throw new IllegalStateException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger c = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex(), (byte)3);
        return c.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte getValueByte() {
        if (super.getType() != 66) {
            throw new IllegalStateException("Dont call getValueByte() on a non BYTE ElementValue");
        }
        ConstantInteger c = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex(), (byte)3);
        return (byte)c.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char getValueChar() {
        if (super.getType() != 67) {
            throw new IllegalStateException("Dont call getValueChar() on a non CHAR ElementValue");
        }
        ConstantInteger c = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex(), (byte)3);
        return (char)c.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getValueLong() {
        if (super.getType() != 74) {
            throw new IllegalStateException("Dont call getValueLong() on a non LONG ElementValue");
        }
        ConstantLong j = (ConstantLong)super.getConstantPool().getConstant(this.getIndex());
        return j.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float getValueFloat() {
        if (super.getType() != 70) {
            throw new IllegalStateException("Dont call getValueFloat() on a non FLOAT ElementValue");
        }
        ConstantFloat f = (ConstantFloat)super.getConstantPool().getConstant(this.getIndex());
        return f.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown double getValueDouble() {
        if (super.getType() != 68) {
            throw new IllegalStateException("Dont call getValueDouble() on a non DOUBLE ElementValue");
        }
        ConstantDouble d = (ConstantDouble)super.getConstantPool().getConstant(this.getIndex());
        return d.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean getValueBoolean() {
        if (super.getType() != 90) {
            throw new IllegalStateException("Dont call getValueBoolean() on a non BOOLEAN ElementValue");
        }
        ConstantInteger bo = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex());
        return bo.getBytes() != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short getValueShort() {
        if (super.getType() != 83) {
            throw new IllegalStateException("Dont call getValueShort() on a non SHORT ElementValue");
        }
        ConstantInteger s2 = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex());
        return (short)s2.getBytes();
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return this.stringifyValue();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String stringifyValue() {
        ConstantPool cpool = super.getConstantPool();
        int _type = super.getType();
        switch (_type) {
            case 73: {
                ConstantInteger c = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(c.getBytes());
            }
            case 74: {
                ConstantLong j = (ConstantLong)cpool.getConstant(this.getIndex(), (byte)5);
                return Long.toString(j.getBytes());
            }
            case 68: {
                ConstantDouble d = (ConstantDouble)cpool.getConstant(this.getIndex(), (byte)6);
                return Double.toString(d.getBytes());
            }
            case 70: {
                ConstantFloat f = (ConstantFloat)cpool.getConstant(this.getIndex(), (byte)4);
                return Float.toString(f.getBytes());
            }
            case 83: {
                ConstantInteger s2 = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(s2.getBytes());
            }
            case 66: {
                ConstantInteger b = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(b.getBytes());
            }
            case 67: {
                ConstantInteger ch = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                return String.valueOf((char)ch.getBytes());
            }
            case 90: {
                ConstantInteger bo = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                if (bo.getBytes() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                ConstantUtf8 cu8 = (ConstantUtf8)cpool.getConstant(this.getIndex(), (byte)1);
                return cu8.getBytes();
            }
        }
        throw new IllegalStateException("SimpleElementValue class does not know how to stringify type " + _type);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        int _type = super.getType();
        dos.writeByte(_type);
        switch (_type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dos.writeShort(this.getIndex());
                break;
            }
            default: {
                throw new IllegalStateException("SimpleElementValue doesnt know how to write out type " + _type);
            }
        }
    }
}

