/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.Attribute;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.LocalVariable;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTypeTable
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] localVariableTypeTable;

    public LocalVariableTypeTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTypeTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTypeTable(), c.getConstantPool());
    }

    public LocalVariableTypeTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] local_variable_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)17, name_index, length, constant_pool);
        this.localVariableTypeTable = local_variable_table;
    }

    LocalVariableTypeTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIdx, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int len, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(nameIdx, len, (LocalVariable[])null, cpool);
        int local_variable_type_table_length = input.readUnsignedShort();
        this.localVariableTypeTable = new LocalVariable[local_variable_type_table_length];
        for (int i = 0; i < local_variable_type_table_length; ++i) {
            this.localVariableTypeTable[i] = new LocalVariable(input, cpool);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitLocalVariableTypeTable(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.localVariableTypeTable.length);
        for (LocalVariable variable : this.localVariableTypeTable) {
            variable.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getLocalVariableTypeTable() {
        return this.localVariableTypeTable;
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown LocalVariable getLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        for (LocalVariable variable : this.localVariableTypeTable) {
            if (variable.getIndex() != index) continue;
            return variable;
        }
        return null;
    }

    public final void setLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] local_variable_table) {
        this.localVariableTypeTable = local_variable_table;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.localVariableTypeTable.length; ++i) {
            buf.append(this.localVariableTypeTable[i].toStringShared(true));
            if (i >= this.localVariableTypeTable.length - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        LocalVariableTypeTable c = (LocalVariableTypeTable)this.clone();
        c.localVariableTypeTable = new LocalVariable[this.localVariableTypeTable.length];
        for (int i = 0; i < this.localVariableTypeTable.length; ++i) {
            c.localVariableTypeTable[i] = this.localVariableTypeTable[i].copy();
        }
        c.setConstantPool(constant_pool);
        return c;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTableLength() {
        return this.localVariableTypeTable == null ? 0 : this.localVariableTypeTable.length;
    }
}

