/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.AccessFlags;
import coveredclass.org.apache.bcel.classfile.AnnotationEntry;
import coveredclass.org.apache.bcel.classfile.Attribute;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.Field;
import coveredclass.org.apache.bcel.classfile.InnerClass;
import coveredclass.org.apache.bcel.classfile.InnerClasses;
import coveredclass.org.apache.bcel.classfile.Method;
import coveredclass.org.apache.bcel.classfile.Node;
import coveredclass.org.apache.bcel.classfile.SourceFile;
import coveredclass.org.apache.bcel.classfile.Utility;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.apache.bcel.generic.Type;
import coveredclass.org.apache.bcel.util.BCELComparator;
import coveredclass.org.apache.bcel.util.ClassQueue;
import coveredclass.org.apache.bcel.util.Repository;
import coveredclass.org.apache.bcel.util.SyntheticRepository;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node,
Comparable<JavaClass> {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String packageName;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String sourceFileName = "<Unknown>";
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int classNameIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclassNameIndex;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String superclassName;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaceNames;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] fields;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methods;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @MonotonicNonNull @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown [] annotations;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte source = 1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isAnonymous = false;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isNested = false;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean computedNestedTypeStatus = false;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte HEAP = 1;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte FILE = 2;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte ZIP = 3;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean debug = Boolean.getBoolean("JavaClass.debug");
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            JavaClass THIS = (JavaClass)o1;
            JavaClass THAT = (JavaClass)o2;
            return Objects.equals(THIS.getClassName(), THAT.getClassName());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            JavaClass THIS = (JavaClass)o;
            return THIS.getClassName().hashCode();
        }
    };
    private transient @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Repository repository = SyntheticRepository.getInstance();

    public JavaClass(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int classNameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclassNameIndex, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] fields, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methods, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte source) {
        super(access_flags);
        if (interfaces == null) {
            interfaces = new int[]{};
        }
        if (attributes == null) {
            attributes = new Attribute[]{};
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        if (methods == null) {
            methods = new Method[]{};
        }
        this.classNameIndex = classNameIndex;
        this.superclassNameIndex = superclassNameIndex;
        this.fileName = fileName;
        this.major = major;
        this.minor = minor;
        this.constantPool = constantPool;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
        this.source = source;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof SourceFile)) continue;
            this.sourceFileName = ((SourceFile)attribute).getSourceFileName();
            break;
        }
        this.className = constantPool.getConstantString(classNameIndex, (byte)7);
        this.className = Utility.compactClassName(this.className, false);
        int index = this.className.lastIndexOf(46);
        this.packageName = index < 0 ? "" : this.className.substring(0, index);
        if (superclassNameIndex > 0) {
            this.superclassName = constantPool.getConstantString(superclassNameIndex, (byte)7);
            this.superclassName = Utility.compactClassName(this.superclassName, false);
        } else {
            this.superclassName = "java.lang.Object";
        }
        this.interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            String str = constantPool.getConstantString(interfaces[i], (byte)7);
            this.interfaceNames[i] = Utility.compactClassName(str, false);
        }
    }

    public JavaClass(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int classNameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclassNameIndex, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] fields, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methods, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes) {
        this(classNameIndex, superclassNameIndex, fileName, major, minor, access_flags, constantPool, interfaces, fields, methods, attributes, 1);
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitJavaClass(this);
    }

    static void Debug(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str) {
        if (debug) {
            System.out.println(str);
        }
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown File file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        File dir;
        String parent = file.getParent();
        if (parent != null && !(dir = new File(parent)).mkdirs() && !dir.isDirectory()) {
            throw new IOException("Could not create the directory " + dir);
        }
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
            this.dump(dos);
        }
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String _file_name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.dump(new File(_file_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBytes() {
        ByteArrayOutputStream s2 = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(s2);
        try {
            this.dump(ds);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ds.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return s2.toByteArray();
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown OutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.dump(new DataOutputStream(file));
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeInt(-889275714);
        file.writeShort(this.minor);
        file.writeShort(this.major);
        this.constantPool.dump(file);
        file.writeShort(super.getAccessFlags());
        file.writeShort(this.classNameIndex);
        file.writeShort(this.superclassNameIndex);
        file.writeShort(this.interfaces.length);
        for (int interface1 : this.interfaces) {
            file.writeShort(interface1);
        }
        file.writeShort(this.fields.length);
        for (Field field : this.fields) {
            field.dump(file);
        }
        file.writeShort(this.methods.length);
        for (Method method : this.methods) {
            method.dump(file);
        }
        if (this.attributes != null) {
            file.writeShort(this.attributes.length);
            for (Attribute attribute : this.attributes) {
                attribute.dump(file);
            }
        } else {
            file.writeShort(0);
        }
        file.flush();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAttributes() {
        return this.attributes;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAnnotationEntries() {
        if (this.annotations == null) {
            this.annotations = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotations;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getClassName() {
        return this.className;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getPackageName() {
        return this.packageName;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getClassNameIndex() {
        return this.classNameIndex;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getFields() {
        return this.fields;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getFileName() {
        return this.fileName;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaceNames() {
        return this.interfaceNames;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaceIndices() {
        return this.interfaces;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMajor() {
        return this.major;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getMethods() {
        return this.methods;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Method getMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown java.lang.reflect.Method m4) {
        for (Method method : this.methods) {
            if (!m4.getName().equals(method.getName()) || m4.getModifiers() != method.getModifiers() || !Type.getSignature(m4).equals(method.getSignature())) continue;
            return method;
        }
        return null;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMinor() {
        return this.minor;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSourceFileName() {
        return this.sourceFileName;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSuperclassName() {
        return this.superclassName;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSuperclassNameIndex() {
        return this.superclassNameIndex;
    }

    public void setAttributes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes) {
        this.attributes = attributes;
    }

    public void setClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) {
        this.className = className;
    }

    public void setClassNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int classNameIndex) {
        this.classNameIndex = classNameIndex;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setFields(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] fields) {
        this.fields = fields;
    }

    public void setFileName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName) {
        this.fileName = fileName;
    }

    public void setInterfaceNames(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaceNames) {
        this.interfaceNames = interfaceNames;
    }

    public void setInterfaces(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces) {
        this.interfaces = interfaces;
    }

    public void setMajor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major) {
        this.major = major;
    }

    public void setMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methods) {
        this.methods = methods;
    }

    public void setMinor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor) {
        this.minor = minor;
    }

    public void setSourceFileName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void setSuperclassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String superclassName) {
        this.superclassName = superclassName;
    }

    public void setSuperclassNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclassNameIndex) {
        this.superclassNameIndex = superclassNameIndex;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        AnnotationEntry[] annotations;
        String access = Utility.accessToString(super.getAccessFlags(), true);
        access = access.isEmpty() ? "" : access + " ";
        StringBuilder buf = new StringBuilder(128);
        buf.append(access).append(Utility.classOrInterface(super.getAccessFlags())).append(" ").append(this.className).append(" extends ").append(Utility.compactClassName(this.superclassName, false)).append('\n');
        int size = this.interfaces.length;
        if (size > 0) {
            buf.append("implements\t\t");
            for (int i = 0; i < size; ++i) {
                buf.append(this.interfaceNames[i]);
                if (i >= size - 1) continue;
                buf.append(", ");
            }
            buf.append('\n');
        }
        buf.append("file name\t\t").append(this.fileName).append('\n');
        buf.append("compiled from\t\t").append(this.sourceFileName).append('\n');
        buf.append("compiler version\t").append(this.major).append(".").append(this.minor).append('\n');
        buf.append("access flags\t\t").append(super.getAccessFlags()).append('\n');
        buf.append("constant pool\t\t").append(this.constantPool.getLength()).append(" entries\n");
        buf.append("ACC_SUPER flag\t\t").append(this.isSuper()).append("\n");
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s):\n");
            for (Attribute attribute : this.attributes) {
                buf.append(JavaClass.indent(attribute));
            }
        }
        if ((annotations = this.getAnnotationEntries()) != null && annotations.length > 0) {
            buf.append("\nAnnotation(s):\n");
            for (AnnotationEntry annotation : annotations) {
                buf.append(JavaClass.indent(annotation));
            }
        }
        if (this.fields.length > 0) {
            buf.append("\n").append(this.fields.length).append(" fields:\n");
            for (Field field : this.fields) {
                buf.append("\t").append(field).append('\n');
            }
        }
        if (this.methods.length > 0) {
            buf.append("\n").append(this.methods.length).append(" methods:\n");
            for (Method method : this.methods) {
                buf.append("\t").append(method).append('\n');
            }
        }
        return buf.toString();
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String indent(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object obj) {
        StringTokenizer tok = new StringTokenizer(obj.toString(), "\n");
        StringBuilder buf = new StringBuilder();
        while (tok.hasMoreTokens()) {
            buf.append("\t").append(tok.nextToken()).append("\n");
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass copy() {
        JavaClass c = null;
        try {
            int i;
            c = (JavaClass)this.clone();
            c.constantPool = this.constantPool.copy();
            c.interfaces = (int[])this.interfaces.clone();
            c.interfaceNames = (String[])this.interfaceNames.clone();
            c.fields = new Field[this.fields.length];
            for (i = 0; i < this.fields.length; ++i) {
                c.fields[i] = this.fields[i].copy(c.constantPool);
            }
            c.methods = new Method[this.methods.length];
            for (i = 0; i < this.methods.length; ++i) {
                c.methods[i] = this.methods[i].copy(c.constantPool);
            }
            c.attributes = new Attribute[this.attributes.length];
            for (i = 0; i < this.attributes.length; ++i) {
                c.attributes[i] = this.attributes[i].copy(c.constantPool);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isSuper() {
        return (super.getAccessFlags() & 0x20) != 0;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isClass() {
        return (super.getAccessFlags() & 0x200) == 0;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isAnonymous() {
        this.computeNestedTypeStatus();
        return this.isAnonymous;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isNested() {
        this.computeNestedTypeStatus();
        return this.isNested;
    }

    private void computeNestedTypeStatus() {
        if (this.computedNestedTypeStatus) {
            return;
        }
        for (Attribute attribute : this.attributes) {
            InnerClass[] innerClasses;
            if (!(attribute instanceof InnerClasses)) continue;
            for (InnerClass innerClasse : innerClasses = ((InnerClasses)attribute).getInnerClasses()) {
                boolean innerClassAttributeRefersToMe = false;
                String inner_class_name = this.constantPool.getConstantString(innerClasse.getInnerClassIndex(), (byte)7);
                if ((inner_class_name = Utility.compactClassName(inner_class_name, false)).equals(this.getClassName())) {
                    innerClassAttributeRefersToMe = true;
                }
                if (!innerClassAttributeRefersToMe) continue;
                this.isNested = true;
                if (innerClasse.getInnerNameIndex() != 0) continue;
                this.isAnonymous = true;
            }
        }
        this.computedNestedTypeStatus = true;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte getSource() {
        return this.source;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Repository getRepository() {
        return this.repository;
    }

    public void setRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Repository repository) {
        this.repository = repository;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean instanceOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass super_class) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass[] super_classes;
        if (this.equals(super_class)) {
            return true;
        }
        for (JavaClass super_classe : super_classes = this.getSuperClasses()) {
            if (!super_classe.equals(super_class)) continue;
            return true;
        }
        if (super_class.isInterface()) {
            return this.implementationOf(super_class);
        }
        return false;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean implementationOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass inter) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass[] super_interfaces;
        if (!inter.isInterface()) {
            throw new IllegalArgumentException(inter.getClassName() + " is no interface");
        }
        if (this.equals(inter)) {
            return true;
        }
        for (JavaClass super_interface : super_interfaces = this.getAllInterfaces()) {
            if (!super_interface.equals(inter)) continue;
            return true;
        }
        return false;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown JavaClass getSuperClass() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        return this.repository.loadClass(this.getSuperclassName());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getSuperClasses() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass clazz = this;
        ArrayList<JavaClass> allSuperClasses = new ArrayList<JavaClass>();
        for (clazz = clazz.getSuperClass(); clazz != null; clazz = clazz.getSuperClass()) {
            allSuperClasses.add(clazz);
        }
        return allSuperClasses.toArray(new JavaClass[allSuperClasses.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaces() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        String[] _interfaces = this.getInterfaceNames();
        JavaClass[] classes = new JavaClass[_interfaces.length];
        for (int i = 0; i < _interfaces.length; ++i) {
            classes[i] = this.repository.loadClass(_interfaces[i]);
        }
        return classes;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAllInterfaces() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        ClassQueue queue = new ClassQueue();
        TreeSet<JavaClass> allInterfaces = new TreeSet<JavaClass>();
        queue.enqueue(this);
        while (!queue.empty()) {
            JavaClass clazz = queue.dequeue();
            JavaClass souper = clazz.getSuperClass();
            JavaClass[] _interfaces = clazz.getInterfaces();
            if (clazz.isInterface()) {
                allInterfaces.add(clazz);
            } else if (souper != null) {
                queue.enqueue(souper);
            }
            for (JavaClass _interface : _interfaces) {
                queue.enqueue(_interface);
            }
        }
        return allInterfaces.toArray(new JavaClass[allInterfaces.size()]);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        bcelComparator = comparator;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object obj) {
        return bcelComparator.equals(this, obj);
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int compareTo(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass obj) {
        return this.getClassName().compareTo(obj.getClassName());
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

