/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.Attribute;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.InnerClass;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClasses
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] innerClasses;

    public InnerClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClasses c) {
        this(c.getNameIndex(), c.getLength(), c.getInnerClasses(), c.getConstantPool());
    }

    public InnerClasses(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown [] innerClasses, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)6, name_index, length, constant_pool);
        this.innerClasses = innerClasses != null ? innerClasses : new InnerClass[]{};
    }

    InnerClasses(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (InnerClass[])null, constant_pool);
        int number_of_classes = input.readUnsignedShort();
        this.innerClasses = new InnerClass[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            this.innerClasses[i] = new InnerClass(input);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitInnerClasses(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.innerClasses.length);
        for (InnerClass inner_class : this.innerClasses) {
            inner_class.dump(file);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInnerClasses() {
        return this.innerClasses;
    }

    public void setInnerClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] innerClasses) {
        this.innerClasses = innerClasses != null ? innerClasses : new InnerClass[]{};
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("InnerClasses(");
        buf.append(this.innerClasses.length);
        buf.append("):\n");
        for (InnerClass inner_class : this.innerClasses) {
            buf.append(inner_class.toString(super.getConstantPool())).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        InnerClasses c = (InnerClasses)this.clone();
        c.innerClasses = new InnerClass[this.innerClasses.length];
        for (int i = 0; i < this.innerClasses.length; ++i) {
            c.innerClasses[i] = this.innerClasses[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

