/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.ConstantUtf8;
import coveredclass.org.apache.bcel.classfile.ElementValue;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.io.DataOutputStream;
import java.io.IOException;

public class ElementValuePair {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue elementValue;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int elementNameIndex;

    public ElementValuePair(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int elementNameIndex, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue elementValue, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        this.elementValue = elementValue;
        this.elementNameIndex = elementNameIndex;
        this.constantPool = constantPool;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getNameString() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.elementNameIndex, (byte)1);
        return c.getBytes();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue getValue() {
        return this.elementValue;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.elementNameIndex;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toShortString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getNameString()).append("=").append(this.getValue().toShortString());
        return result.toString();
    }

    protected void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeShort(this.elementNameIndex);
        this.elementValue.dump(dos);
    }
}

