/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.Constant;
import coveredclass.org.apache.bcel.classfile.ConstantObject;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.ConstantUtf8;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantString
extends Constant
implements ConstantObject {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stringIndex;

    public ConstantString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantString c) {
        this(c.getStringIndex());
    }

    ConstantString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort());
    }

    public ConstantString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stringIndex) {
        super((byte)8);
        this.stringIndex = stringIndex;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitConstantString(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.stringIndex);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getStringIndex() {
        return this.stringIndex;
    }

    public void setStringIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stringIndex) {
        this.stringIndex = stringIndex;
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return super.toString() + "(stringIndex = " + this.stringIndex + ")";
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object getConstantValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        Constant c = cp.getConstant(this.stringIndex, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }
}

