/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.Attribute;
import coveredclass.org.apache.bcel.classfile.BootstrapMethod;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class BootstrapMethods
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrapMethods;

    public BootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethods c) {
        this(c.getNameIndex(), c.getLength(), c.getBootstrapMethods(), c.getConstantPool());
    }

    public BootstrapMethods(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrapMethods, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)20, name_index, length, constant_pool);
        this.bootstrapMethods = bootstrapMethods;
    }

    BootstrapMethods(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (BootstrapMethod[])null, constant_pool);
        int num_bootstrap_methods = input.readUnsignedShort();
        this.bootstrapMethods = new BootstrapMethod[num_bootstrap_methods];
        for (int i = 0; i < num_bootstrap_methods; ++i) {
            this.bootstrapMethods[i] = new BootstrapMethod(input);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBootstrapMethods() {
        return this.bootstrapMethods;
    }

    public final void setBootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrapMethods) {
        this.bootstrapMethods = bootstrapMethods;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitBootstrapMethods(this);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethods copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        BootstrapMethods c = (BootstrapMethods)this.clone();
        c.bootstrapMethods = new BootstrapMethod[this.bootstrapMethods.length];
        for (int i = 0; i < this.bootstrapMethods.length; ++i) {
            c.bootstrapMethods[i] = this.bootstrapMethods[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.bootstrapMethods.length);
        for (BootstrapMethod bootstrap_method : this.bootstrapMethods) {
            bootstrap_method.dump(file);
        }
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("BootstrapMethods(");
        buf.append(this.bootstrapMethods.length);
        buf.append("):");
        for (int i = 0; i < this.bootstrapMethods.length; ++i) {
            buf.append("\n");
            int start = buf.length();
            buf.append("  ").append(i).append(": ");
            int indent_count = buf.length() - start;
            String[] lines = this.bootstrapMethods[i].toString(super.getConstantPool()).split("\\r?\\n");
            buf.append(lines[0]);
            for (int j = 1; j < lines.length; ++j) {
                buf.append("\n").append("          ".substring(0, indent_count)).append(lines[j]);
            }
        }
        return buf.toString();
    }
}

