/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.javassist.bytecode.annotation;

import coveredclass.javassist.ClassPool;
import coveredclass.javassist.bytecode.ConstPool;
import coveredclass.javassist.bytecode.annotation.AnnotationsWriter;
import coveredclass.javassist.bytecode.annotation.MemberValue;
import coveredclass.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class IntegerMemberValue
extends MemberValue {
    int valueIndex;

    public IntegerMemberValue(int index, ConstPool cp) {
        super('I', cp);
        this.valueIndex = index;
    }

    public IntegerMemberValue(ConstPool cp, int value) {
        super('I', cp);
        this.setValue(value);
    }

    public IntegerMemberValue(ConstPool cp) {
        super('I', cp);
        this.setValue(0);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m4) {
        return this.getValue();
    }

    @Override
    Class<?> getType(ClassLoader cl) {
        return Integer.TYPE;
    }

    public int getValue() {
        return this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(int newValue) {
        this.valueIndex = this.cp.addIntegerInfo(newValue);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitIntegerMemberValue(this);
    }
}

