/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.verifier.structurals;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import replacecall.org.apache.bcel.Repository;
import replacecall.org.apache.bcel.classfile.JavaClass;
import replacecall.org.apache.bcel.classfile.Method;
import replacecall.org.apache.bcel.generic.ConstantPoolGen;
import replacecall.org.apache.bcel.generic.JsrInstruction;
import replacecall.org.apache.bcel.generic.MethodGen;
import replacecall.org.apache.bcel.generic.ObjectType;
import replacecall.org.apache.bcel.generic.RET;
import replacecall.org.apache.bcel.generic.ReferenceType;
import replacecall.org.apache.bcel.generic.ReturnInstruction;
import replacecall.org.apache.bcel.generic.ReturnaddressType;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.apache.bcel.verifier.PassVerifier;
import replacecall.org.apache.bcel.verifier.VerificationResult;
import replacecall.org.apache.bcel.verifier.Verifier;
import replacecall.org.apache.bcel.verifier.exc.AssertionViolatedException;
import replacecall.org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import replacecall.org.apache.bcel.verifier.exc.VerifierConstraintViolatedException;
import replacecall.org.apache.bcel.verifier.structurals.ControlFlowGraph;
import replacecall.org.apache.bcel.verifier.structurals.ExceptionHandler;
import replacecall.org.apache.bcel.verifier.structurals.ExecutionVisitor;
import replacecall.org.apache.bcel.verifier.structurals.Frame;
import replacecall.org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import replacecall.org.apache.bcel.verifier.structurals.InstructionContext;
import replacecall.org.apache.bcel.verifier.structurals.OperandStack;
import replacecall.org.apache.bcel.verifier.structurals.UninitializedObjectType;
import replacecall.org.checkerframework.checker.index.qual.NonNegative;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;

public final class Pass3bVerifier
extends PassVerifier {
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean DEBUG = true;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier myOwner;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int methodNo;

    public Pass3bVerifier(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier owner, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int method_no) {
        this.myOwner = owner;
        this.methodNo = method_no;
    }

    /*
     * Unable to fully structure code
     */
    private void circulationPump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen m, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ControlFlowGraph cfg, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext start, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame vanillaFrame, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstConstraintVisitor icv, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExecutionVisitor ev) {
        random = new Random();
        icq = new InstructionContextQueue();
        start.execute(vanillaFrame, new ArrayList<InstructionContext>(), icv, ev);
        icq.add(start, new ArrayList<InstructionContext>());
        while (!icq.isEmpty()) {
            u = icq.getIC(0);
            ec = icq.getEC(0);
            icq.remove(0);
            oldchain = (ArrayList)ec.clone();
            newchain = (ArrayList)ec.clone();
            newchain.add(u);
            if (u.getInstruction().getInstruction() instanceof RET) {
                ret = (RET)u.getInstruction().getInstruction();
                t = (ReturnaddressType)u.getOutFrame(oldchain).getLocals().get(ret.getIndex());
                theSuccessor = cfg.contextOf(t.getTarget());
                lastJSR = null;
                skip_jsr = 0;
                for (ss = oldchain.size() - 1; ss >= 0; --ss) {
                    if (skip_jsr < 0) {
                        throw new AssertionViolatedException("More RET than JSR in execution chain?!");
                    }
                    if (((InstructionContext)oldchain.get(ss)).getInstruction().getInstruction() instanceof JsrInstruction) {
                        if (skip_jsr == 0) {
                            lastJSR = (InstructionContext)oldchain.get(ss);
                            break;
                        }
                        --skip_jsr;
                    }
                    if (!(((InstructionContext)oldchain.get(ss)).getInstruction().getInstruction() instanceof RET)) continue;
                    ++skip_jsr;
                }
                if (lastJSR == null) {
                    throw new AssertionViolatedException("RET without a JSR before in ExecutionChain?! EC: '" + oldchain + "'.");
                }
                jsr = (JsrInstruction)lastJSR.getInstruction().getInstruction();
                if (theSuccessor != cfg.contextOf(jsr.physicalSuccessor())) {
                    throw new AssertionViolatedException("RET '" + u.getInstruction() + "' info inconsistent: jump back to '" + theSuccessor + "' or '" + cfg.contextOf(jsr.physicalSuccessor()) + "'?");
                }
                if (theSuccessor.execute(u.getOutFrame(oldchain), newchain, icv, ev)) {
                    newchainClone = (ArrayList)newchain.clone();
                    icq.add(theSuccessor, newchainClone);
                }
            } else {
                succs = u.getSuccessors();
                for (InstructionContext v : succs) {
                    if (!v.execute(u.getOutFrame(oldchain), newchain, icv, ev)) continue;
                    newchainClone = (ArrayList)newchain.clone();
                    icq.add(v, newchainClone);
                }
            }
            exc_hds = u.getExceptionHandlers();
            for (ExceptionHandler exc_hd : exc_hds) {
                v = cfg.contextOf(exc_hd.getHandlerStart());
                if (!v.execute(new Frame(u.getOutFrame(oldchain).getLocals(), new OperandStack(u.getOutFrame(oldchain).getStack().maxStack(), exc_hd.getExceptionType() == null ? Type.THROWABLE : exc_hd.getExceptionType())), new ArrayList<InstructionContext>(), icv, ev)) continue;
                icq.add(v, new ArrayList<InstructionContext>());
            }
        }
        ih = start.getInstruction();
        do {
            if (!(ih.getInstruction() instanceof ReturnInstruction) || cfg.isDead(ih)) continue;
            ic = cfg.contextOf(ih);
            f = ic.getOutFrame(new ArrayList<InstructionContext>());
            lvs = f.getLocals();
            for (i = 0; i < lvs.maxLocals(); ++i) {
                if (!(lvs.get(i) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + ic + "' may leave method with an uninitialized object in the local variables array '" + lvs + "'.");
            }
            os = f.getStack();
            for (i = 0; i < os.size(); ++i) {
                if (!(os.peek(i) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + ic + "' may leave method with an uninitialized object on the operand stack '" + os + "'.");
            }
            returnedType = null;
            inStack = ic.getInFrame().getStack();
            returnedType = inStack.size() >= 1 ? inStack.peek() : Type.VOID;
            if (returnedType == null) continue;
            if (returnedType instanceof ReferenceType) {
                try {
                    if (((ReferenceType)returnedType).isCastableTo(m.getReturnType())) ** GOTO lbl81
                    this.invalidReturnTypeError(returnedType, m);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                if (returnedType.equals(m.getReturnType().normalizeForStackOrLocal())) continue;
                this.invalidReturnTypeError(returnedType, m);
            }
lbl81:
            // 6 sources

        } while ((ih = ih.getNext()) != null);
    }

    public void invalidReturnTypeError(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type returnedType, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen m4) {
        throw new StructuralCodeConstraintException("Returned type " + returnedType + " does not match Method's return type " + m4.getReturnType());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerificationResult do_verify() {
        JavaClass jc;
        if (!this.myOwner.doPass3a(this.methodNo).equals(VerificationResult.VR_OK)) {
            return VerificationResult.VR_NOTYET;
        }
        try {
            jc = Repository.lookupClass(this.myOwner.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(jc.getConstantPool());
        InstConstraintVisitor icv = new InstConstraintVisitor();
        icv.setConstantPoolGen(constantPoolGen);
        ExecutionVisitor ev = new ExecutionVisitor();
        ev.setConstantPoolGen(constantPoolGen);
        Method[] methods = jc.getMethods();
        try {
            MethodGen mg = new MethodGen(methods[this.methodNo], this.myOwner.getClassName(), constantPoolGen);
            icv.setMethodGen(mg);
            if (!mg.isAbstract() && !mg.isNative()) {
                ControlFlowGraph cfg = new ControlFlowGraph(mg);
                Frame f = new Frame(mg.getMaxLocals(), mg.getMaxStack());
                if (!mg.isStatic()) {
                    if (mg.getName().equals("<init>")) {
                        Frame.setThis(new UninitializedObjectType(ObjectType.getInstance(jc.getClassName())));
                        f.getLocals().set(0, Frame.getThis());
                    } else {
                        Frame.setThis(null);
                        f.getLocals().set(0, ObjectType.getInstance(jc.getClassName()));
                    }
                }
                Type[] argtypes = mg.getArgumentTypes();
                int twoslotoffset = 0;
                for (int j = 0; j < argtypes.length; ++j) {
                    if (argtypes[j] == Type.SHORT || argtypes[j] == Type.BYTE || argtypes[j] == Type.CHAR || argtypes[j] == Type.BOOLEAN) {
                        argtypes[j] = Type.INT;
                    }
                    f.getLocals().set(twoslotoffset + j + (mg.isStatic() ? 0 : 1), argtypes[j]);
                    if (argtypes[j].getSize() != 2) continue;
                    f.getLocals().set(++twoslotoffset + j + (mg.isStatic() ? 0 : 1), Type.UNKNOWN);
                }
                this.circulationPump(mg, cfg, cfg.contextOf(mg.getInstructionList().getStart()), f, icv, ev);
            }
        }
        catch (VerifierConstraintViolatedException ce) {
            ce.extendMessage("Constraint violated in method '" + methods[this.methodNo] + "':\n", "");
            return new VerificationResult(2, ce.getMessage());
        }
        catch (RuntimeException re) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            re.printStackTrace(pw);
            throw new AssertionViolatedException("Some RuntimeException occured while verify()ing class '" + jc.getClassName() + "', method '" + methods[this.methodNo] + "'. Original RuntimeException's stack trace:\n---\n" + sw + "---\n", re);
        }
        return VerificationResult.VR_OK;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMethodNo() {
        return this.methodNo;
    }

    private static final class InstructionContextQueue {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext> ics = new Vector<InstructionContext>();
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext>> ecs = new Vector<ArrayList<InstructionContext>>();

        private InstructionContextQueue() {
        }

        public void add(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext ic, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext> executionChain) {
            this.ics.add(ic);
            this.ecs.add(executionChain);
        }

        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isEmpty() {
            return this.ics.isEmpty();
        }

        public void remove(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
            this.ics.remove(i);
            this.ecs.remove(i);
        }

        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext getIC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
            return this.ics.get(i);
        }

        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext> getEC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
            return this.ecs.get(i);
        }

        @Pure
        public @NonNegative @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size() {
            return this.ics.size();
        }
    }
}

