/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.verifier.structurals;

import java.util.ArrayList;
import replacecall.org.apache.bcel.generic.ObjectType;
import replacecall.org.apache.bcel.generic.ReferenceType;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.apache.bcel.verifier.exc.AssertionViolatedException;
import replacecall.org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import replacecall.org.apache.bcel.verifier.structurals.UninitializedObjectType;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public class OperandStack
implements Cloneable {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type> stack = new ArrayList();
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int maxStack;

    public OperandStack(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int maxStack) {
        this.maxStack = maxStack;
    }

    public OperandStack(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int maxStack, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType obj) {
        this.maxStack = maxStack;
        this.push(obj);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        ArrayList clone;
        OperandStack newstack = new OperandStack(this.maxStack);
        newstack.stack = clone = (ArrayList)this.stack.clone();
        return newstack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.stack.hashCode();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object o) {
        if (!(o instanceof OperandStack)) {
            return false;
        }
        OperandStack s2 = (OperandStack)o;
        return this.stack.equals(s2.stack);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int maxStack() {
        return this.maxStack;
    }

    @Pure
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type peek() {
        return this.peek(0);
    }

    @Pure
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type peek(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        return this.stack.get(this.size() - i - 1);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type pop() {
        Type e = this.stack.remove(this.size() - 1);
        return e;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Type pop(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        for (int j = 0; j < i; ++j) {
            this.pop();
        }
        return null;
    }

    public void push(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        if (type == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type == Type.BOOLEAN || type == Type.CHAR || type == Type.BYTE || type == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size() {
        return this.stack.size();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slotsUsed() {
        int slots = 0;
        for (int i = 0; i < this.stack.size(); ++i) {
            slots += this.peek(i).getSize();
        }
        return slots;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Slots used: ");
        sb.append(this.slotsUsed());
        sb.append(" MaxStack: ");
        sb.append(this.maxStack);
        sb.append(".\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.peek(i));
            sb.append(" (Size: ");
            sb.append(String.valueOf(this.peek(i).getSize()));
            sb.append(")\n");
        }
        return sb.toString();
    }

    public void merge(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown OperandStack s2) {
        try {
            if (this.slotsUsed() != s2.slotsUsed() || this.size() != s2.size()) {
                throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + s2);
            }
            for (int i = 0; i < this.size(); ++i) {
                if (!(this.stack.get(i) instanceof UninitializedObjectType) && s2.stack.get(i) instanceof UninitializedObjectType) {
                    throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
                }
                if (!this.stack.get(i).equals(s2.stack.get(i)) && this.stack.get(i) instanceof UninitializedObjectType && !(s2.stack.get(i) instanceof UninitializedObjectType)) {
                    throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
                }
                if (this.stack.get(i) instanceof UninitializedObjectType && !(s2.stack.get(i) instanceof UninitializedObjectType)) {
                    this.stack.set(i, ((UninitializedObjectType)this.stack.get(i)).getInitialized());
                }
                if (this.stack.get(i).equals(s2.stack.get(i))) continue;
                if (this.stack.get(i) instanceof ReferenceType && s2.stack.get(i) instanceof ReferenceType) {
                    this.stack.set(i, ((ReferenceType)this.stack.get(i)).getFirstCommonSuperclass((ReferenceType)s2.stack.get(i)));
                    continue;
                }
                throw new StructuralCodeConstraintException("Cannot merge stacks of different types:\nStack A:\n" + this + "\nStack B:\n" + s2);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    public void initializeObject(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown UninitializedObjectType u) {
        for (int i = 0; i < this.stack.size(); ++i) {
            if (this.stack.get(i) != u) continue;
            this.stack.set(i, u.getInitialized());
        }
    }
}

