/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;
import replacecall.org.apache.bcel.Const;
import replacecall.org.apache.bcel.classfile.Attribute;
import replacecall.org.apache.bcel.classfile.Code;
import replacecall.org.apache.bcel.classfile.CodeException;
import replacecall.org.apache.bcel.classfile.ConstantCP;
import replacecall.org.apache.bcel.classfile.ConstantFieldref;
import replacecall.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import replacecall.org.apache.bcel.classfile.ConstantInvokeDynamic;
import replacecall.org.apache.bcel.classfile.ConstantMethodref;
import replacecall.org.apache.bcel.classfile.ConstantNameAndType;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.LocalVariable;
import replacecall.org.apache.bcel.classfile.LocalVariableTable;
import replacecall.org.apache.bcel.classfile.Method;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.apache.bcel.util.ByteSequence;
import replacecall.org.apache.bcel.util.Class2HTML;
import replacecall.org.apache.bcel.util.ConstantHTML;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import replacecall.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

final class CodeHTML {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PrintWriter file;
    private @MonotonicNonNull @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown BitSet gotoSet;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantHTML constantHtml;
    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide = false;

    CodeHTML(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String dir, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methods, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantHTML constant_html) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.className = class_name;
        this.constantPool = constant_pool;
        this.constantHtml = constant_html;
        this.file = new PrintWriter(new FileOutputStream(dir + class_name + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        for (int i = 0; i < methods.length; ++i) {
            this.writeMethod(methods[i], i);
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String codeToHTML(@UnknownInitialization(value=CodeHTML.class) CodeHTML this, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int method_number) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        int i;
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuilder buf = new StringBuilder(256);
        buf.append("<TT>").append(Const.getOpcodeName(opcode)).append("</TT></TD><TD>");
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            for (i = 0; i < no_pad_bytes; ++i) {
                bytes.readByte();
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                int[] jump_table = new int[high - low + 1];
                for (int i2 = 0; i2 < jump_table.length; ++i2) {
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append("<TH>").append(low + i2).append("</TH>");
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                for (int element : jump_table) {
                    buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(element).append("\">").append(element).append("</A></TD>");
                }
                buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(default_offset).append("\">").append(default_offset).append("</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] jump_table = new int[npairs];
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                for (i = 0; i < npairs; ++i) {
                    int match = bytes.readInt();
                    jump_table[i] = offset + bytes.readInt();
                    buf.append("<TH>").append(match).append("</TH>");
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                for (i = 0; i < npairs; ++i) {
                    buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(jump_table[i]).append("\">").append(jump_table[i]).append("</A></TD>");
                }
                buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(default_offset).append("\">").append(default_offset).append("</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int index = bytes.getIndex() + bytes.readShort() - 1;
                buf.append("<A HREF=\"#code").append(method_number).append("@").append(index).append("\">").append(index).append("</A>");
                break;
            }
            case 200: 
            case 201: {
                int windex = bytes.getIndex() + bytes.readInt() - 1;
                buf.append("<A HREF=\"#code").append(method_number).append("@").append(windex).append("\">").append(windex).append("</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("%").append(vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("(wide)");
                break;
            }
            case 188: {
                buf.append("<FONT COLOR=\"#00FF00\">").append(Const.getTypeName(bytes.readByte())).append("</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readShort();
                ConstantFieldref c1 = (ConstantFieldref)this.constantPool.getConstant(index, (byte)9);
                int class_index = c1.getClassIndex();
                String name = this.constantPool.getConstantString(class_index, (byte)7);
                name = Utility.compactClassName(name, false);
                index = c1.getNameAndTypeIndex();
                String field_name = this.constantPool.constantToString(index, (byte)12);
                if (name.equals(this.className)) {
                    buf.append("<A HREF=\"").append(this.className).append("_methods.html#field").append(field_name).append("\" TARGET=Methods>").append(field_name).append("</A>\n");
                    break;
                }
                buf.append(this.constantHtml.referenceConstant(class_index)).append(".").append(field_name);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short index = bytes.readShort();
                buf.append(this.constantHtml.referenceConstant(index));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                String name;
                int index;
                int class_index;
                ConstantCP c;
                short m_index = bytes.readShort();
                if (opcode == 185) {
                    bytes.readUnsignedByte();
                    bytes.readUnsignedByte();
                    c = (ConstantInterfaceMethodref)this.constantPool.getConstant(m_index, (byte)11);
                    class_index = c.getClassIndex();
                    index = c.getNameAndTypeIndex();
                    name = Class2HTML.referenceClass(class_index);
                } else if (opcode == 186) {
                    bytes.readUnsignedByte();
                    bytes.readUnsignedByte();
                    c = (ConstantInvokeDynamic)this.constantPool.getConstant(m_index, (byte)18);
                    index = c.getNameAndTypeIndex();
                    name = "#" + ((ConstantInvokeDynamic)c).getBootstrapMethodAttrIndex();
                } else {
                    c = (ConstantMethodref)this.constantPool.getConstant(m_index, (byte)10);
                    class_index = c.getClassIndex();
                    index = c.getNameAndTypeIndex();
                    name = Class2HTML.referenceClass(class_index);
                }
                String str = Class2HTML.toHTML(this.constantPool.constantToString(this.constantPool.getConstant(index, (byte)12)));
                ConstantNameAndType c2 = (ConstantNameAndType)this.constantPool.getConstant(index, (byte)12);
                String signature = this.constantPool.constantToString(c2.getSignatureIndex(), (byte)1);
                String[] args = Utility.methodSignatureArgumentTypes(signature, false);
                String type = Utility.methodSignatureReturnType(signature, false);
                buf.append(name).append(".<A HREF=\"").append(this.className).append("_cp.html#cp").append(m_index).append("\" TARGET=ConstantPool>").append(str).append("</A>").append("(");
                for (int i3 = 0; i3 < args.length; ++i3) {
                    buf.append(Class2HTML.referenceType(args[i3]));
                    if (i3 >= args.length - 1) continue;
                    buf.append(", ");
                }
                buf.append("):").append(Class2HTML.referenceType(type));
                break;
            }
            case 19: 
            case 20: {
                short index = bytes.readShort();
                buf.append("<A HREF=\"").append(this.className).append("_cp.html#cp").append(index).append("\" TARGET=\"ConstantPool\">").append(Class2HTML.toHTML(this.constantPool.constantToString(index, this.constantPool.getConstant(index).getTag()))).append("</a>");
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("<A HREF=\"").append(this.className).append("_cp.html#cp").append(index).append("\" TARGET=\"ConstantPool\">").append(Class2HTML.toHTML(this.constantPool.constantToString(index, this.constantPool.getConstant(index).getTag()))).append("</a>");
                break;
            }
            case 189: {
                short index = bytes.readShort();
                buf.append(this.constantHtml.referenceConstant(index));
                break;
            }
            case 197: {
                short index = bytes.readShort();
                byte dimensions = bytes.readByte();
                buf.append(this.constantHtml.referenceConstant(index)).append(":").append(dimensions).append("-dimensional");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("%").append(vindex).append(" ").append(constant);
                break;
            }
            default: {
                if (Const.getNoOfOperands(opcode) <= 0) break;
                int i4 = 0;
                while ((long)i4 < Const.getOperandTypeCount(opcode)) {
                    switch (Const.getOperandType(opcode, i4)) {
                        case 8: {
                            buf.append(bytes.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable default case reached! " + Const.getOperandType(opcode, i4));
                        }
                    }
                    buf.append("&nbsp;");
                    ++i4;
                }
                break block0;
            }
        }
        buf.append("</TD>");
        return buf.toString();
    }

    @EnsuresNonNull(value={"goto_set"})
    private void findGotos(@UnknownInitialization(value=CodeHTML.class) CodeHTML this, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Code code) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.gotoSet = new BitSet(bytes.available());
        if (code != null) {
            Attribute[] attributes;
            CodeException[] ce;
            for (CodeException cex : ce = code.getExceptionTable()) {
                this.gotoSet.set(cex.getStartPC());
                this.gotoSet.set(cex.getEndPC());
                this.gotoSet.set(cex.getHandlerPC());
            }
            for (Attribute attribute : attributes = code.getAttributes()) {
                LocalVariable[] vars;
                if (attribute.getTag() != 5) continue;
                for (LocalVariable var : vars = ((LocalVariableTable)attribute).getLocalVariableTable()) {
                    int start = var.getStartPC();
                    int end = start + var.getLength();
                    this.gotoSet.set(start);
                    this.gotoSet.set(end);
                }
                break;
            }
        }
        block8: while (bytes.available() > 0) {
            int opcode = bytes.readUnsignedByte();
            switch (opcode) {
                case 170: 
                case 171: {
                    int index;
                    int offset;
                    int remainder = bytes.getIndex() % 4;
                    int no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
                    for (int j = 0; j < no_pad_bytes; ++j) {
                        bytes.readByte();
                    }
                    int default_offset = bytes.readInt();
                    if (opcode == 170) {
                        int low = bytes.readInt();
                        int high = bytes.readInt();
                        offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                        this.gotoSet.set(default_offset += offset);
                        for (int j = 0; j < high - low + 1; ++j) {
                            index = offset + bytes.readInt();
                            this.gotoSet.set(index);
                        }
                        continue block8;
                    }
                    int npairs = bytes.readInt();
                    offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                    this.gotoSet.set(default_offset += offset);
                    for (int j = 0; j < npairs; ++j) {
                        bytes.readInt();
                        index = offset + bytes.readInt();
                        this.gotoSet.set(index);
                    }
                    continue block8;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int index = bytes.getIndex() + bytes.readShort() - 1;
                    this.gotoSet.set(index);
                    continue block8;
                }
                case 200: 
                case 201: {
                    int index = bytes.getIndex() + bytes.readInt() - 1;
                    this.gotoSet.set(index);
                    continue block8;
                }
            }
            bytes.unreadByte();
            this.codeToHTML(bytes, 0);
        }
    }

    private void writeMethod(@UnknownInitialization(value=CodeHTML.class) CodeHTML this, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method method, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int method_number) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        String signature = method.getSignature();
        String[] args = Utility.methodSignatureArgumentTypes(signature, false);
        String type = Utility.methodSignatureReturnType(signature, false);
        String name = method.getName();
        String html_name = Class2HTML.toHTML(name);
        String access = Utility.accessToString(method.getAccessFlags());
        access = Utility.replace(access, " ", "&nbsp;");
        Attribute[] attributes = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + access + "</FONT>&nbsp;<A NAME=method" + method_number + ">" + Class2HTML.referenceType(type) + "</A>&nbsp<A HREF=\"" + this.className + "_methods.html#method" + method_number + "\" TARGET=Methods>" + html_name + "</A>(");
        for (int i = 0; i < args.length; ++i) {
            this.file.print(Class2HTML.referenceType(args[i]));
            if (i >= args.length - 1) continue;
            this.file.print(",&nbsp;");
        }
        this.file.println(")</B></P>");
        Code c = null;
        byte[] code = null;
        if (attributes.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            for (int i = 0; i < attributes.length; ++i) {
                byte tag = attributes[i].getTag();
                if (tag != -1) {
                    this.file.print("<LI><A HREF=\"" + this.className + "_attributes.html#method" + method_number + "@" + i + "\" TARGET=Attributes>" + Const.getAttributeName(tag) + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributes[i] + "</LI>");
                }
                if (tag != 2) continue;
                c = (Code)attributes[i];
                Attribute[] attributes2 = c.getAttributes();
                code = c.getCode();
                this.file.print("<UL>");
                for (int j = 0; j < attributes2.length; ++j) {
                    tag = attributes2[j].getTag();
                    this.file.print("<LI><A HREF=\"" + this.className + "_attributes.html#method" + method_number + "@" + i + "@" + j + "\" TARGET=Attributes>" + Const.getAttributeName(tag) + "</A></LI>\n");
                }
                this.file.print("</UL>");
            }
            this.file.println("</UL>");
        }
        if (code != null) {
            try (ByteSequence stream = new ByteSequence(code);){
                stream.mark(stream.available());
                this.findGotos(stream, c);
                stream.reset();
                this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
                while (stream.available() > 0) {
                    int offset = stream.getIndex();
                    String str = this.codeToHTML(stream, method_number);
                    String anchor = "";
                    if (this.gotoSet.get(offset)) {
                        anchor = "<A NAME=code" + method_number + "@" + offset + "></A>";
                    }
                    String anchor2 = stream.getIndex() == code.length ? "<A NAME=code" + method_number + "@" + code.length + ">" + offset + "</A>" : "" + offset;
                    this.file.println("<TR VALIGN=TOP><TD>" + anchor2 + "</TD><TD>" + anchor + str + "</TR>");
                }
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

