/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import replacecall.org.apache.bcel.classfile.AnnotationEntry;
import replacecall.org.apache.bcel.classfile.Annotations;
import replacecall.org.apache.bcel.classfile.Attribute;
import replacecall.org.apache.bcel.classfile.Code;
import replacecall.org.apache.bcel.classfile.CodeException;
import replacecall.org.apache.bcel.classfile.ExceptionTable;
import replacecall.org.apache.bcel.classfile.LineNumber;
import replacecall.org.apache.bcel.classfile.LineNumberTable;
import replacecall.org.apache.bcel.classfile.LocalVariable;
import replacecall.org.apache.bcel.classfile.LocalVariableTable;
import replacecall.org.apache.bcel.classfile.LocalVariableTypeTable;
import replacecall.org.apache.bcel.classfile.Method;
import replacecall.org.apache.bcel.classfile.ParameterAnnotationEntry;
import replacecall.org.apache.bcel.classfile.ParameterAnnotations;
import replacecall.org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.apache.bcel.generic.AnnotationEntryGen;
import replacecall.org.apache.bcel.generic.BranchInstruction;
import replacecall.org.apache.bcel.generic.ClassGenException;
import replacecall.org.apache.bcel.generic.CodeExceptionGen;
import replacecall.org.apache.bcel.generic.ConstantPoolGen;
import replacecall.org.apache.bcel.generic.FieldGenOrMethodGen;
import replacecall.org.apache.bcel.generic.IINC;
import replacecall.org.apache.bcel.generic.IfInstruction;
import replacecall.org.apache.bcel.generic.IndexedInstruction;
import replacecall.org.apache.bcel.generic.Instruction;
import replacecall.org.apache.bcel.generic.InstructionHandle;
import replacecall.org.apache.bcel.generic.InstructionList;
import replacecall.org.apache.bcel.generic.InstructionTargeter;
import replacecall.org.apache.bcel.generic.LineNumberGen;
import replacecall.org.apache.bcel.generic.LocalVariableGen;
import replacecall.org.apache.bcel.generic.LocalVariableInstruction;
import replacecall.org.apache.bcel.generic.MethodObserver;
import replacecall.org.apache.bcel.generic.NOP;
import replacecall.org.apache.bcel.generic.ObjectType;
import replacecall.org.apache.bcel.generic.RET;
import replacecall.org.apache.bcel.generic.Select;
import replacecall.org.apache.bcel.generic.TargetLostException;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.apache.bcel.generic.TypedInstruction;
import replacecall.org.apache.bcel.util.BCELComparator;
import replacecall.org.checkerframework.checker.index.qual.NonNegative;
import replacecall.org.checkerframework.checker.index.qual.SameLen;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.BinaryName;
import replacecall.org.checkerframework.checker.signature.qual.ClassGetName;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public class MethodGen
extends FieldGenOrMethodGen {
    private @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] argTypes;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] argNames;
    private @NonNegative @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int maxLocals;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int maxStack;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList il;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean stripAttributes;
    private @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown LocalVariableTypeTable localVariableTypeTable = null;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen> variableList = new ArrayList<LocalVariableGen>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberGen> lineNumberList = new ArrayList<LineNumberGen>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen> exceptionList = new ArrayList<CodeExceptionGen>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String> throwsList = new ArrayList<String>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute> codeAttrsList = new ArrayList<Attribute>();
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen> @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] paramAnnotations;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean hasParameterAnnotations = false;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean haveUnpackedParameterAnnotations = false;
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            MethodGen THIS = (MethodGen)o1;
            MethodGen THAT = (MethodGen)o2;
            return Objects.equals(THIS.getName(), THAT.getName()) && Objects.equals(THIS.getSignature(), THAT.getSignature());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            MethodGen THIS = (MethodGen)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodObserver> observers;

    public MethodGen(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type return_type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] argTypes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown [] argNames, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String method_name, @Nullable @BinaryName @UnknownInterned @UnknownKeyFor @Initialized String className, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList il, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        super(access_flags);
        this.setType(return_type);
        this.setArgumentTypes(argTypes);
        this.setArgumentNames(argNames);
        this.setName(method_name);
        this.setClassName(className);
        this.setInstructionList(il);
        this.setConstantPool(cp);
        boolean abstract_ = this.isAbstract() || this.isNative();
        InstructionHandle start = null;
        InstructionHandle end = null;
        if (!abstract_) {
            start = il.getStart();
            if (!this.isStatic() && className != null) {
                this.addLocalVariable("this", ObjectType.getInstance(className), start, end);
            }
        }
        if (argTypes != null) {
            int size = argTypes.length;
            for (Type arg_type : argTypes) {
                if (Type.VOID != arg_type) continue;
                throw new ClassGenException("'void' is an illegal argument type for a method");
            }
            if (argNames != null) {
                if (size != argNames.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + argNames.length);
                }
            } else {
                argNames = new String[size];
                for (int i = 0; i < size; ++i) {
                    argNames[i] = "arg" + i;
                }
                this.setArgumentNames(argNames);
            }
            if (!abstract_) {
                for (int i = 0; i < size; ++i) {
                    this.addLocalVariable(argNames[i], argTypes[i], start, end);
                }
            }
        }
    }

    public MethodGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method method, @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        this(method.getAccessFlags(), Type.getReturnType(method.getSignature()), Type.getArgumentTypes(method.getSignature()), null, method.getName(), className, (method.getAccessFlags() & 0x500) == 0 ? new InstructionList(MethodGen.getByteCodes(method)) : null, cp);
        Attribute[] attributes;
        for (Attribute attribute : attributes = method.getAttributes()) {
            Attribute a = attribute;
            if (a instanceof Code) {
                Attribute[] c_attributes;
                Code c = (Code)a;
                this.setMaxStack(c.getMaxStack());
                this.setMaxLocals(c.getMaxLocals());
                Object[] ces = c.getExceptionTable();
                if (ces != null) {
                    for (Object ce : ces) {
                        InstructionHandle end;
                        int type = ((CodeException)ce).getCatchType();
                        ObjectType c_type = null;
                        if (type > 0) {
                            @ClassGetName String cen = method.getConstantPool().getConstantString(type, (byte)7);
                            c_type = ObjectType.getInstance(cen);
                        }
                        int end_pc = ((CodeException)ce).getEndPC();
                        int length = MethodGen.getByteCodes(method).length;
                        if (length == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(((CodeException)ce).getStartPC()), end, this.il.findHandle(((CodeException)ce).getHandlerPC()), c_type);
                    }
                }
                Attribute[] attributeArray = c_attributes = c.getAttributes();
                int n = attributeArray.length;
                for (int ce = 0; ce < n; ++ce) {
                    Attribute c_attribute = attributeArray[ce];
                    a = c_attribute;
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln;
                        for (LineNumber l : ln = ((LineNumberTable)a).getLineNumberTable()) {
                            InstructionHandle ih = this.il.findHandle(l.getStartPC());
                            if (ih == null) continue;
                            this.addLineNumber(ih, l.getLineNumber());
                        }
                        continue;
                    }
                    if (a instanceof LocalVariableTable) {
                        this.updateLocalVariableTable((LocalVariableTable)a);
                        continue;
                    }
                    if (a instanceof LocalVariableTypeTable) {
                        this.localVariableTypeTable = (LocalVariableTypeTable)a.copy(cp.getConstantPool());
                        continue;
                    }
                    this.addCodeAttribute(a);
                }
                continue;
            }
            if (a instanceof ExceptionTable) {
                String[] names = ((ExceptionTable)a).getExceptionNames();
                for (String name2 : names) {
                    this.addException(name2);
                }
                continue;
            }
            if (a instanceof Annotations) {
                AnnotationEntry[] aes;
                Annotations runtimeAnnotations = (Annotations)a;
                for (AnnotationEntry element : aes = runtimeAnnotations.getAnnotationEntries()) {
                    this.addAnnotationEntry(new AnnotationEntryGen(element, cp, false));
                }
                continue;
            }
            this.addAttribute(a);
        }
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getByteCodes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method method) {
        Code code = method.getCode();
        if (code == null) {
            throw new IllegalStateException(String.format("The method '%s' has no code.", method));
        }
        return code.getCode();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen addLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slot, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int orig_index) {
        byte t2 = type.getType();
        if (t2 != 16) {
            LocalVariableGen l;
            int i;
            int add = type.getSize();
            if (slot + add > this.maxLocals) {
                this.maxLocals = slot + add;
            }
            if ((i = this.variableList.indexOf(l = new LocalVariableGen(slot, name, type, start, end, orig_index))) >= 0) {
                this.variableList.set(i, l);
            } else {
                this.variableList.add(l);
            }
            return l;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen addLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slot, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end) {
        return this.addLocalVariable(name, type, slot, start, end, slot);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen addLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InstructionHandle start, @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InstructionHandle end) {
        return this.addLocalVariable(name, type, this.maxLocals, start, end);
    }

    public void removeLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen l) {
        l.dispose();
        this.variableList.remove(l);
    }

    public void removeLocalVariables() {
        for (LocalVariableGen lv : this.variableList) {
            lv.dispose();
        }
        this.variableList.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getLocalVariables() {
        int size = this.variableList.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.variableList.toArray(lg);
        for (int i = 0; i < size; ++i) {
            if (lg[i].getStart() == null && this.il != null) {
                lg[i].setStart(this.il.getStart());
            }
            if (lg[i].getEnd() != null || this.il == null) continue;
            lg[i].setEnd(this.il.getEnd());
        }
        if (size > 1) {
            Arrays.sort(lg, (o1, o2) -> o1.getIndex() - o2.getIndex());
        }
        return lg;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable getLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        for (int i = 0; i < size; ++i) {
            lv[i] = lg[i].getLocalVariable(cp);
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTypeTable getLocalVariableTypeTable() {
        return this.localVariableTypeTable;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberGen addLineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int srcLine) {
        LineNumberGen l = new LineNumberGen(ih, srcLine);
        this.lineNumberList.add(l);
        return l;
    }

    public void removeLineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberGen l) {
        this.lineNumberList.remove(l);
    }

    public void removeLineNumbers() {
        this.lineNumberList.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.lineNumberList.size()];
        this.lineNumberList.toArray(lg);
        return lg;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberTable getLineNumberTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        int size = this.lineNumberList.size();
        LineNumber[] ln = new LineNumber[size];
        for (int i = 0; i < size; ++i) {
            ln[i] = this.lineNumberList.get(i).getLineNumber();
        }
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen addExceptionHandler(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle handler_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exceptionList.add(c);
        return c;
    }

    public void removeExceptionHandler(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen c) {
        this.exceptionList.remove(c);
    }

    public void removeExceptionHandlers() {
        this.exceptionList.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exceptionList.size()];
        this.exceptionList.toArray(cg);
        return cg;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getCodeExceptions() {
        int size = this.exceptionList.size();
        CodeException[] c_exc = new CodeException[size];
        for (int i = 0; i < size; ++i) {
            CodeExceptionGen c = this.exceptionList.get(i);
            c_exc[i] = c.getCodeException(super.getConstantPool());
        }
        return c_exc;
    }

    public void addException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) {
        this.throwsList.add(className);
    }

    public void removeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String c) {
        this.throwsList.remove(c);
    }

    public void removeExceptions() {
        this.throwsList.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptions() {
        String[] e = new String[this.throwsList.size()];
        this.throwsList.toArray(e);
        return e;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionTable getExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        int size = this.throwsList.size();
        int[] ex = new int[size];
        for (int i = 0; i < size; ++i) {
            ex[i] = cp.addClass(this.throwsList.get(i));
        }
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public void addCodeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute a) {
        this.codeAttrsList.add(a);
    }

    public void removeLocalVariableTypeTable() {
        this.localVariableTypeTable = null;
    }

    public void removeCodeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute a) {
        this.codeAttrsList.remove(a);
    }

    public void removeCodeAttributes() {
        this.localVariableTypeTable = null;
        this.codeAttrsList.clear();
    }

    @Pure
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getCodeAttributes() {
        Attribute[] attributes = new Attribute[this.codeAttrsList.size()];
        this.codeAttrsList.toArray(attributes);
        return attributes;
    }

    public void addAnnotationsAsAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        Attribute[] attrs;
        for (Attribute attr : attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries())) {
            this.addAttribute(attr);
        }
    }

    public void addParameterAnnotationsAsAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        if (!this.hasParameterAnnotations) {
            return;
        }
        Attribute[] attrs = AnnotationEntryGen.getParameterAnnotationAttributes(cp, this.paramAnnotations);
        if (attrs != null) {
            for (Attribute attr : attrs) {
                this.addAttribute(attr);
            }
        }
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] addRuntimeAnnotationsAsAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        Attribute[] attrs;
        for (Attribute attr : attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries())) {
            this.addAttribute(attr);
        }
        return attrs;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] addRuntimeParameterAnnotationsAsAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        Attribute[] attrs;
        if (!this.hasParameterAnnotations) {
            return new Attribute[0];
        }
        for (Attribute attr : attrs = AnnotationEntryGen.getParameterAnnotationAttributes(cp, this.paramAnnotations)) {
            this.addAttribute(attr);
        }
        return attrs;
    }

    public void removeRuntimeAttributes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attrs) {
        for (Attribute attr : attrs) {
            this.removeAttribute(attr);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method getMethod() {
        String signature = this.getSignature();
        ConstantPoolGen _cp = super.getConstantPool();
        int name_index = _cp.addUtf8(super.getName());
        int signature_index = _cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.variableList.size() > 0 && !this.stripAttributes) {
            this.updateLocalVariableTable(this.getLocalVariableTable(_cp));
            lvt = this.getLocalVariableTable(_cp);
            this.addCodeAttribute(lvt);
        }
        if (this.localVariableTypeTable != null) {
            if (lvt != null) {
                this.adjustLocalVariableTypeTable(lvt);
            }
            this.addCodeAttribute(this.localVariableTypeTable);
        }
        if (this.lineNumberList.size() > 0 && !this.stripAttributes) {
            lnt = this.getLineNumberTable(_cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        for (Attribute code_attr : code_attrs) {
            attrs_len += code_attr.getLength() + 6;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract() && !this.isNative()) {
            Attribute[] attributes;
            for (Attribute a : attributes = this.getAttributes()) {
                if (!(a instanceof Code)) continue;
                this.removeAttribute(a);
            }
            code = new Code(_cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.maxStack, this.maxLocals, byte_code, c_exc, code_attrs, _cp.getConstantPool());
            this.addAttribute(code);
        }
        Attribute[] annotations = this.addRuntimeAnnotationsAsAttribute(_cp);
        Attribute[] parameterAnnotations = this.addRuntimeParameterAnnotationsAsAttribute(_cp);
        ExceptionTable et = null;
        if (this.throwsList.size() > 0) {
            et = this.getExceptionTable(_cp);
            this.addAttribute(et);
        }
        Method m4 = new Method(super.getAccessFlags(), name_index, signature_index, this.getAttributes(), _cp.getConstantPool());
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (this.localVariableTypeTable != null) {
            this.removeCodeAttribute(this.localVariableTypeTable);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        this.removeRuntimeAttributes(annotations);
        this.removeRuntimeAttributes(parameterAnnotations);
        return m4;
    }

    private void updateLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable a) {
        LocalVariable[] lv = a.getLocalVariableTable();
        this.removeLocalVariables();
        for (LocalVariable l : lv) {
            InstructionHandle start = this.il.findHandle(l.getStartPC());
            InstructionHandle end = this.il.findHandle(l.getStartPC() + l.getLength());
            if (null == start) {
                start = this.il.getStart();
            }
            this.addLocalVariable(l.getName(), Type.getType(l.getSignature()), l.getIndex(), start, end, l.getOrigIndex());
        }
    }

    private void adjustLocalVariableTypeTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable lvt) {
        LocalVariable[] lvg;
        LocalVariable[] lv = lvt.getLocalVariableTable();
        block0: for (LocalVariable element : lvg = this.localVariableTypeTable.getLocalVariableTypeTable()) {
            for (LocalVariable l : lv) {
                if (!element.getName().equals(l.getName()) || element.getIndex() != l.getOrigIndex()) continue;
                element.setLength(l.getLength());
                element.setStartPC(l.getStartPC());
                element.setIndex(l.getIndex());
                continue block0;
            }
        }
    }

    public void removeNOPs() {
        if (this.il != null) {
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                InstructionHandle next = ih.getNext();
                if (next != null && ih.getInstruction() instanceof NOP) {
                    try {
                        this.il.delete(ih);
                    }
                    catch (TargetLostException e) {
                        for (InstructionHandle target : e.getTargets()) {
                            for (InstructionTargeter targeter : target.getTargeters()) {
                                targeter.updateTarget(target, next);
                            }
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setMaxLocals(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int m4) {
        this.maxLocals = m4;
    }

    public @NonNegative @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxStack(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int m4) {
        this.maxStack = m4;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMaxStack() {
        return this.maxStack;
    }

    public @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getClassName() {
        return this.className;
    }

    public void setClassName(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String class_name) {
        this.className = class_name;
    }

    public void setReturnType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type return_type) {
        this.setType(return_type);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_types) {
        this.argTypes = arg_types;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @SameLen(value={"this.getArgumentNames()", "this.getArgumentTypes()"}) @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getArgumentTypes() {
        return (Type[])this.argTypes.clone();
    }

    public void setArgumentType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        this.argTypes[i] = type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getArgumentType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        return this.argTypes[i];
    }

    public void setArgumentNames(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_names) {
        this.argNames = arg_names;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @SameLen(value={"this.getArgumentNames()", "this.getArgumentTypes()"}) @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getArgumentNames() {
        return (String[])this.argNames.clone();
    }

    public void setArgumentName(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        this.argNames[i] = name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getArgumentName(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        return this.argNames[i];
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList il) {
        this.il = il;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSignature() {
        return Type.getMethodSignature(super.getType(), this.argTypes);
    }

    public void setMaxStack() {
        this.maxStack = this.il != null ? MethodGen.getMaxStack(super.getConstantPool(), this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max;
            int n = max = this.isStatic() ? 0 : 1;
            if (this.argTypes != null) {
                for (Type arg_type : this.argTypes) {
                    max += arg_type.getSize();
                }
            }
            for (InstructionHandle ih = this.il.getStart(); ih != null; ih = ih.getNext()) {
                int index;
                Instruction ins = ih.getInstruction();
                if (!(ins instanceof LocalVariableInstruction) && !(ins instanceof RET) && !(ins instanceof IINC) || (index = ((IndexedInstruction)((Object)ins)).getIndex() + ((TypedInstruction)((Object)ins)).getType(super.getConstantPool()).getSize()) <= max) continue;
                max = index;
            }
            this.maxLocals = max;
        } else {
            this.maxLocals = 0;
        }
    }

    public void stripAttributes(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean flag) {
        this.stripAttributes = flag;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMaxStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList il, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] et) {
        BranchStack branchTargets = new BranchStack();
        for (CodeExceptionGen element : et) {
            InstructionHandle handler_pc = element.getHandlerPC();
            if (handler_pc == null) continue;
            branchTargets.push(handler_pc, 1);
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            Instruction instruction = ih.getInstruction();
            short opcode = instruction.getOpcode();
            int delta = instruction.produceStack(cp) - instruction.consumeStack(cp);
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    InstructionHandle[] targets;
                    Select select = (Select)branch;
                    for (InstructionHandle target : targets = select.getTargets()) {
                        branchTargets.push(target, stackDepth);
                    }
                    ih = null;
                } else if (!(branch instanceof IfInstruction)) {
                    if (opcode == 168 || opcode == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public void addObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<MethodObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (MethodObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        String signature = Type.getMethodSignature(super.getType(), this.argTypes);
        signature = Utility.methodSignatureToString(signature, super.getName(), access, true, this.getLocalVariableTable(super.getConstantPool()));
        StringBuilder buf = new StringBuilder(signature);
        for (Attribute a : this.getAttributes()) {
            if (a instanceof Code || a instanceof ExceptionTable) continue;
            buf.append(" [").append(a).append("]");
        }
        if (this.throwsList.size() > 0) {
            for (String throwsDescriptor : this.throwsList) {
                buf.append("\n\t\tthrows ").append(throwsDescriptor);
            }
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen copy(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        Method m4 = ((MethodGen)this.clone()).getMethod();
        MethodGen mg = new MethodGen(m4, className, super.getConstantPool());
        if (super.getConstantPool() != cp) {
            mg.setConstantPool(cp);
            mg.getInstructionList().replaceConstantPool(super.getConstantPool(), cp);
        }
        return mg;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen> getAnnotationsOnParameter(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations || i > this.argTypes.length) {
            return null;
        }
        return this.paramAnnotations[i];
    }

    private void ensureExistingParameterAnnotationsUnpacked() {
        if (this.haveUnpackedParameterAnnotations) {
            return;
        }
        Attribute[] attrs = this.getAttributes();
        ParameterAnnotations paramAnnVisAttr = null;
        ParameterAnnotations paramAnnInvisAttr = null;
        for (Attribute attribute : attrs) {
            if (!(attribute instanceof ParameterAnnotations)) continue;
            if (!this.hasParameterAnnotations) {
                List[] parmList = new List[this.argTypes.length];
                this.paramAnnotations = parmList;
                for (int j = 0; j < this.argTypes.length; ++j) {
                    this.paramAnnotations[j] = new ArrayList<AnnotationEntryGen>();
                }
            }
            this.hasParameterAnnotations = true;
            ParameterAnnotations rpa = (ParameterAnnotations)attribute;
            if (rpa instanceof RuntimeVisibleParameterAnnotations) {
                paramAnnVisAttr = rpa;
            } else {
                paramAnnInvisAttr = rpa;
            }
            ParameterAnnotationEntry[] parameterAnnotationEntries = rpa.getParameterAnnotationEntries();
            for (int j = 0; j < parameterAnnotationEntries.length; ++j) {
                ParameterAnnotationEntry immutableArray = rpa.getParameterAnnotationEntries()[j];
                List<AnnotationEntryGen> mutable = this.makeMutableVersion(immutableArray.getAnnotationEntries());
                this.paramAnnotations[j].addAll(mutable);
            }
        }
        if (paramAnnVisAttr != null) {
            this.removeAttribute(paramAnnVisAttr);
        }
        if (paramAnnInvisAttr != null) {
            this.removeAttribute(paramAnnInvisAttr);
        }
        this.haveUnpackedParameterAnnotations = true;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen> makeMutableVersion(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] mutableArray) {
        ArrayList<AnnotationEntryGen> result = new ArrayList<AnnotationEntryGen>();
        for (AnnotationEntry element : mutableArray) {
            result.add(new AnnotationEntryGen(element, this.getConstantPool(), false));
        }
        return result;
    }

    public void addParameterAnnotation(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int parameterIndex, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen annotation) {
        List<AnnotationEntryGen> existingAnnotations;
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations) {
            List[] parmList = new List[this.argTypes.length];
            this.paramAnnotations = parmList;
            this.hasParameterAnnotations = true;
        }
        if ((existingAnnotations = this.paramAnnotations[parameterIndex]) != null) {
            existingAnnotations.add(annotation);
        } else {
            ArrayList<AnnotationEntryGen> l = new ArrayList<AnnotationEntryGen>();
            l.add(annotation);
            this.paramAnnotations[parameterIndex] = l;
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        bcelComparator = comparator;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object obj) {
        return bcelComparator.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return bcelComparator.hashCode(this);
    }

    static final class BranchStack {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Stack<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchTarget> branchTargets = new Stack();
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Hashtable<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchTarget> visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchTarget visit(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean visited(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }

    static final class BranchTarget {
        final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target;
        final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stackDepth;

        BranchTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }
}

