/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.generic;

import replacecall.org.apache.bcel.classfile.ConstantCP;
import replacecall.org.apache.bcel.classfile.ConstantNameAndType;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.ConstantUtf8;
import replacecall.org.apache.bcel.generic.ArrayType;
import replacecall.org.apache.bcel.generic.CPInstruction;
import replacecall.org.apache.bcel.generic.ClassGenException;
import replacecall.org.apache.bcel.generic.ConstantPoolGen;
import replacecall.org.apache.bcel.generic.LoadClass;
import replacecall.org.apache.bcel.generic.ObjectType;
import replacecall.org.apache.bcel.generic.ReferenceType;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.BinaryName;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class FieldOrMethod
extends CPInstruction
implements LoadClass {
    FieldOrMethod() {
    }

    protected FieldOrMethod(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        super(opcode, index);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return ((ConstantUtf8)cp.getConstant(cnat.getNameIndex())).getBytes();
    }

    @Deprecated
    public @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantCP cmr;
        ConstantPool cp = cpg.getConstantPool();
        String className = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(super.getIndex())).getClassIndex(), (byte)7);
        if (className.startsWith("[")) {
            return "java.lang.Object";
        }
        return className.replace('/', '.');
    }

    @Deprecated
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getClassType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        return ObjectType.getInstance(this.getClassName(cpg));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReferenceType getReferenceType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantCP cmr;
        ConstantPool cp = cpg.getConstantPool();
        String className = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(super.getIndex())).getClassIndex(), (byte)7);
        if (className.startsWith("[")) {
            return (ArrayType)Type.getType(className);
        }
        className = className.replace('/', '.');
        return ObjectType.getInstance(className);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getLoadClassType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ReferenceType rt = this.getReferenceType(cpg);
        if (rt instanceof ObjectType) {
            return (ObjectType)rt;
        }
        throw new ClassGenException(rt.getClass().getCanonicalName() + " " + rt.getSignature() + " does not represent an ObjectType");
    }
}

