/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.generic;

import replacecall.org.apache.bcel.generic.BasicType;
import replacecall.org.apache.bcel.generic.ClassGenException;
import replacecall.org.apache.bcel.generic.ObjectType;
import replacecall.org.apache.bcel.generic.ReferenceType;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.ClassGetName;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;

public final class ArrayType
extends ReferenceType {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int dimensions;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type basicType;

    public ArrayType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int dimensions) {
        this(BasicType.getType(type), dimensions);
    }

    public ArrayType(@ClassGetName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String class_name, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int dimensions) {
        this(ObjectType.getInstance(class_name), dimensions);
    }

    public ArrayType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int dimensions) {
        super((byte)13, "<dummy, will be replaced before end of constructor>");
        if (dimensions < 1 || dimensions > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + dimensions);
        }
        switch (type.getType()) {
            case 13: {
                ArrayType array = (ArrayType)type;
                this.dimensions = dimensions + array.dimensions;
                this.basicType = array.basicType;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = dimensions;
                this.basicType = type;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            buf.append('[');
        }
        buf.append(this.basicType.getSignature());
        super.setSignature(buf.toString());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getBasicType() {
        return this.basicType;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getElementType() {
        if (this.dimensions == 1) {
            return this.basicType;
        }
        return new ArrayType(this.basicType, this.dimensions - 1);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getDimensions() {
        return this.dimensions;
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.basicType.hashCode() ^ this.dimensions;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object _type) {
        if (_type instanceof ArrayType) {
            ArrayType array = (ArrayType)_type;
            return array.dimensions == this.dimensions && array.basicType.equals(this.basicType);
        }
        return false;
    }
}

