/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.Node;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public final class ModuleOpens
implements Cloneable,
Node {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int opensIndex;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int opensFlags;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int opensToCount;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] opensToIndex;

    ModuleOpens(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.opensIndex = file.readUnsignedShort();
        this.opensFlags = file.readUnsignedShort();
        this.opensToCount = file.readUnsignedShort();
        this.opensToIndex = new int[this.opensToCount];
        for (int i = 0; i < this.opensToCount; ++i) {
            this.opensToIndex[i] = file.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModuleOpens(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.opensIndex);
        file.writeShort(this.opensFlags);
        file.writeShort(this.opensToCount);
        for (int entry : this.opensToIndex) {
            file.writeShort(entry);
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "opens(" + this.opensIndex + ", " + this.opensFlags + ", " + this.opensToCount + ", ...)";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String package_name = constant_pool.constantToString(this.opensIndex, (byte)20);
        buf.append(Utility.compactClassName(package_name, false));
        buf.append(", ").append(String.format("%04x", this.opensFlags));
        buf.append(", to(").append(this.opensToCount).append("):\n");
        for (int index : this.opensToIndex) {
            String module_name = constant_pool.getConstantString(index, (byte)19);
            buf.append("      ").append(Utility.compactClassName(module_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleOpens copy() {
        try {
            return (ModuleOpens)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

