/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.Constants;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.ConstantUtf8;
import replacecall.org.apache.bcel.classfile.Node;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.FieldDescriptor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public final class LocalVariable
implements Cloneable,
Node,
Constants {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signatureIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int origIndex;

    public LocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable localVariable) {
        this(localVariable.getStartPC(), localVariable.getLength(), localVariable.getNameIndex(), localVariable.getSignatureIndex(), localVariable.getIndex(), localVariable.getConstantPool());
        this.origIndex = localVariable.getOrigIndex();
    }

    LocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), constant_pool);
    }

    public LocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signatureIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        this.startPc = startPc;
        this.length = length;
        this.nameIndex = nameIndex;
        this.signatureIndex = signatureIndex;
        this.index = index;
        this.constantPool = constantPool;
        this.origIndex = index;
    }

    public LocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signatureIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int origIndex) {
        this.startPc = startPc;
        this.length = length;
        this.nameIndex = nameIndex;
        this.signatureIndex = signatureIndex;
        this.index = index;
        this.constantPool = constantPool;
        this.origIndex = origIndex;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitLocalVariable(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dataOutputStream) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dataOutputStream.writeShort(this.startPc);
        dataOutputStream.writeShort(this.length);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.signatureIndex);
        dataOutputStream.writeShort(this.index);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getLength() {
        return this.length;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.nameIndex, (byte)1);
        return c.getBytes();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.nameIndex;
    }

    public @FieldDescriptor @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.signatureIndex, (byte)1);
        return c.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSignatureIndex() {
        return this.signatureIndex;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.index;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getOrigIndex() {
        return this.origIndex;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getStartPC() {
        return this.startPc;
    }

    @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toStringShared(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean typeTable) {
        String name = this.getName();
        String signature = Utility.signatureToString(this.getSignature(), false);
        String label = "LocalVariable" + (typeTable ? "Types" : "");
        return label + "(startPc = " + this.startPc + ", length = " + this.length + ", index = " + this.index + ":" + signature + " " + name + ")";
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setLength(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length) {
        this.length = length;
    }

    public void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public void setSignatureIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signatureIndex) {
        this.signatureIndex = signatureIndex;
    }

    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        this.index = index;
    }

    public void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc) {
        this.startPc = startPc;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return this.toStringShared(false);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable copy() {
        try {
            return (LocalVariable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

