/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.classfile.Node;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public final class LineNumber
implements Cloneable,
Node {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short startPc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short lineNumber;

    public LineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumber c) {
        this(c.getStartPC(), c.getLineNumber());
    }

    LineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public LineNumber(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lineNumber) {
        this.startPc = (short)startPc;
        this.lineNumber = (short)lineNumber;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitLineNumber(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.startPc);
        file.writeShort(this.lineNumber);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getLineNumber() {
        return 0xFFFF & this.lineNumber;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getStartPC() {
        return 0xFFFF & this.startPc;
    }

    public void setLineNumber(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lineNumber) {
        this.lineNumber = (short)lineNumber;
    }

    public void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc) {
        this.startPc = (short)startPc;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "LineNumber(" + this.startPc + ", " + this.lineNumber + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

