/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;
import replacecall.org.apache.bcel.classfile.Attribute;
import replacecall.org.apache.bcel.classfile.ClassFormatException;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.ConstantValue;
import replacecall.org.apache.bcel.classfile.FieldOrMethod;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.apache.bcel.util.BCELComparator;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public final class Field
extends FieldOrMethod {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            Field THIS = (Field)o1;
            Field THAT = (Field)o2;
            return Objects.equals(THIS.getName(), THAT.getName()) && Objects.equals(THIS.getSignature(), THAT.getSignature());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            Field THIS = (Field)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };

    public Field(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field c) {
        super(c);
    }

    Field(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        super(file, constant_pool);
    }

    public Field(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitField(this);
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ConstantValue getConstantValue() {
        for (Attribute attribute : super.getAttributes()) {
            if (attribute.getTag() != 1) continue;
            return (ConstantValue)attribute;
        }
        return null;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        access = access.isEmpty() ? "" : access + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuilder buf = new StringBuilder(64);
        buf.append(access).append(signature).append(" ").append(name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = ").append(cv);
        }
        for (Attribute attribute : super.getAttributes()) {
            if (attribute instanceof ConstantValue) continue;
            buf.append(" [").append(attribute).append("]");
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        return (Field)this.copy_(_constant_pool);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType() {
        return Type.getReturnType(this.getSignature());
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        bcelComparator = comparator;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object obj) {
        return bcelComparator.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

