/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.ConstantUtf8;
import replacecall.org.apache.bcel.classfile.ElementValue;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class EnumElementValue
extends ElementValue {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int typeIdx;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int valueIdx;

    public EnumElementValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int typeIdx, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int valueIdx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) {
        super(type, cpool);
        if (type != 101) {
            throw new IllegalArgumentException("Only element values of type enum can be built with this ctor - type specified: " + type);
        }
        this.typeIdx = typeIdx;
        this.valueIdx = valueIdx;
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeByte(super.getType());
        dos.writeShort(this.typeIdx);
        dos.writeShort(this.valueIdx);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String stringifyValue() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.valueIdx, (byte)1);
        return cu8.getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getEnumTypeString() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.typeIdx, (byte)1);
        return cu8.getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getEnumValueString() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.valueIdx, (byte)1);
        return cu8.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getValueIndex() {
        return this.valueIdx;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTypeIndex() {
        return this.typeIdx;
    }
}

