/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.Const;
import replacecall.org.apache.bcel.classfile.ClassFormatException;
import replacecall.org.apache.bcel.classfile.Constant;
import replacecall.org.apache.bcel.classfile.ConstantCP;
import replacecall.org.apache.bcel.classfile.ConstantClass;
import replacecall.org.apache.bcel.classfile.ConstantDouble;
import replacecall.org.apache.bcel.classfile.ConstantFloat;
import replacecall.org.apache.bcel.classfile.ConstantInteger;
import replacecall.org.apache.bcel.classfile.ConstantInvokeDynamic;
import replacecall.org.apache.bcel.classfile.ConstantLong;
import replacecall.org.apache.bcel.classfile.ConstantMethodHandle;
import replacecall.org.apache.bcel.classfile.ConstantMethodType;
import replacecall.org.apache.bcel.classfile.ConstantModule;
import replacecall.org.apache.bcel.classfile.ConstantNameAndType;
import replacecall.org.apache.bcel.classfile.ConstantPackage;
import replacecall.org.apache.bcel.classfile.ConstantString;
import replacecall.org.apache.bcel.classfile.ConstantUtf8;
import replacecall.org.apache.bcel.classfile.Node;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public class ConstantPool
implements Cloneable,
Node {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] constantPool;

    public ConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] constantPool) {
        this.constantPool = constantPool;
    }

    public ConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        int constant_pool_count = input.readUnsignedShort();
        this.constantPool = new Constant[constant_pool_count];
        for (int i = 1; i < constant_pool_count; ++i) {
            this.constantPool[i] = Constant.readConstant(input);
            byte tag = this.constantPool[i].getTag();
            if (tag != 6 && tag != 5) continue;
            ++i;
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitConstantPool(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String constantToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant c) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        String str;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                str = "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                str = String.valueOf(((ConstantDouble)c).getBytes());
                break;
            }
            case 4: {
                str = String.valueOf(((ConstantFloat)c).getBytes());
                break;
            }
            case 5: {
                str = String.valueOf(((ConstantLong)c).getBytes());
                break;
            }
            case 3: {
                str = String.valueOf(((ConstantInteger)c).getBytes());
                break;
            }
            case 12: {
                str = this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                str = this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 15: {
                ConstantMethodHandle cmh = (ConstantMethodHandle)c;
                str = Const.getMethodHandleName(cmh.getReferenceKind()) + " " + this.constantToString(cmh.getReferenceIndex(), this.getConstant(cmh.getReferenceIndex()).getTag());
                break;
            }
            case 16: {
                ConstantMethodType cmt = (ConstantMethodType)c;
                str = this.constantToString(cmt.getDescriptorIndex(), (byte)1);
                break;
            }
            case 18: {
                ConstantInvokeDynamic cid = (ConstantInvokeDynamic)c;
                str = cid.getBootstrapMethodAttrIndex() + ":" + this.constantToString(cid.getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 19: {
                int i = ((ConstantModule)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 20: {
                int i = ((ConstantPackage)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constant type " + tag);
            }
        }
        return str;
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String escape(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str) {
        int len = str.length();
        StringBuilder buf = new StringBuilder(len + 5);
        char[] ch = str.toCharArray();
        block7: for (int i = 0; i < len; ++i) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String constantToString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte tag) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        Constant c = this.getConstant(index, tag);
        return this.constantToString(c);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.constantPool.length);
        for (int i = 1; i < this.constantPool.length; ++i) {
            if (this.constantPool[i] == null) continue;
            this.constantPool[i].dump(file);
        }
    }

    @Pure
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant getConstant(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        if (index >= this.constantPool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constantPool.length);
        }
        return this.constantPool[index];
    }

    @Pure
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant getConstant(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte tag) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        Constant c = this.getConstant(index);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index + " is null.");
        }
        if (c.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index + " and got " + c);
        }
        return c;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getConstantPool() {
        return this.constantPool;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getConstantString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte tag) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        int i;
        Constant c = this.getConstant(index, tag);
        switch (tag) {
            case 7: {
                i = ((ConstantClass)c).getNameIndex();
                break;
            }
            case 8: {
                i = ((ConstantString)c).getStringIndex();
                break;
            }
            case 19: {
                i = ((ConstantModule)c).getNameIndex();
                break;
            }
            case 20: {
                i = ((ConstantPackage)c).getNameIndex();
                break;
            }
            default: {
                throw new IllegalArgumentException("getConstantString called with illegal tag " + tag);
            }
        }
        c = this.getConstant(i, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getLength() {
        return this.constantPool == null ? 0 : this.constantPool.length;
    }

    public void setConstant(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant constant) {
        this.constantPool[index] = constant;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] constantPool) {
        this.constantPool = constantPool;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < this.constantPool.length; ++i) {
            buf.append(i).append(")").append(this.constantPool[i]).append("\n");
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool copy() {
        ConstantPool c = null;
        try {
            c = (ConstantPool)this.clone();
            c.constantPool = new Constant[this.constantPool.length];
            for (int i = 1; i < this.constantPool.length; ++i) {
                if (this.constantPool[i] == null) continue;
                c.constantPool[i] = this.constantPool[i].copy();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }
}

